/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.preprocess.css;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wicketstuff.mergedresources.ResourceSpec;
import org.wicketstuff.mergedresources.preprocess.StringResourcePreProcessor;

public class CssUrlRewritingResourcePreProcessor
extends StringResourcePreProcessor {
    private static final long serialVersionUID = 1L;

    @Override
    protected String preProcess(ResourceSpec resourceSpec, String string) {
        if (resourceSpec == null || !resourceSpec.getFile().toLowerCase().endsWith(".css")) {
            return string;
        }
        StringBuffer processedString = new StringBuffer();
        Pattern pattern = Pattern.compile("(url\\s*\\(\\s*\\\"?'?)([^\\\\/].*)(\\s*\\\"?\\'?\\))");
        Matcher urlMatcher = pattern.matcher(string);
        while (urlMatcher.find()) {
            String start = urlMatcher.group(1);
            String path = urlMatcher.group(2);
            String end = urlMatcher.group(3);
            String replacementString = this.getFullPath(resourceSpec, path);
            urlMatcher.appendReplacement(processedString, Matcher.quoteReplacement(start + replacementString + end));
        }
        urlMatcher.appendTail(processedString);
        return processedString.toString();
    }

    private String getFullPath(ResourceSpec resourceSpec, String path) {
        StringBuilder sb = new StringBuilder();
        sb.append(File.separator).append("resources").append(File.separator);
        sb.append(resourceSpec.getScope().getName());
        sb.append(File.separator);
        sb.append(this.getPath(resourceSpec.getFile()));
        sb.append(path);
        return sb.toString();
    }

    private CharSequence getPath(String filePath) {
        File file = new File(filePath);
        String path = file.getPath();
        return path.subSequence(0, Long.valueOf(path.length() - file.getName().length()).intValue());
    }
}

