/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.versioning;

import java.io.IOException;
import java.net.URL;
import org.wicketstuff.mergedresources.versioning.AbstractClasspathResourceVersionProvider;
import org.wicketstuff.mergedresources.versioning.AbstractResourceVersion;
import org.wicketstuff.mergedresources.versioning.IResourceVersionProvider;
import org.wicketstuff.mergedresources.versioning.SimpleResourceVersion;

public class TimestampVersionProvider
extends AbstractClasspathResourceVersionProvider {
    @Override
    public AbstractResourceVersion getVersion(URL url) throws IResourceVersionProvider.VersionException {
        long timestamp = this.getTimestamp(url);
        if (timestamp == 0L) {
            throw new IResourceVersionProvider.VersionException("timestamp not available for " + url);
        }
        return new SimpleResourceVersion((int)(timestamp / 1000L % Integer.MAX_VALUE));
    }

    protected long getTimestamp(URL url) throws IResourceVersionProvider.VersionException {
        try {
            return url.openConnection().getLastModified();
        }
        catch (IOException e) {
            throw new IResourceVersionProvider.VersionException("failed to get lastModified for " + url, e);
        }
    }
}

