/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.versioning;

import org.apache.wicket.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.mergedresources.versioning.AbstractResourceVersion;

public class WicketVersion
extends AbstractResourceVersion {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(WicketVersion.class);
    private String _version;

    public WicketVersion(Application application) {
        this._version = application.getFrameworkSettings().getVersion();
        if ("n/a".equals(this._version)) {
            log.info("failed to determine wicket framework version");
            this._version = null;
        }
    }

    @Override
    protected int compareValid(AbstractResourceVersion o) throws AbstractResourceVersion.IncompatibleVersionsException {
        if (o instanceof WicketVersion) {
            return 0;
        }
        throw new AbstractResourceVersion.IncompatibleVersionsException(this, o);
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public boolean isValid() {
        return this._version != null;
    }
}

