/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.urlcoding;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.target.coding.IRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.coding.SharedResourceRequestTargetUrlCodingStrategy;
import org.wicketstuff.mergedresources.ResourceMount;
import org.wicketstuff.mergedresources.urlcoding.RemoteHostUrlCodingStrategy;

public class RemoteHostResourceMount
extends ResourceMount {
    private final URL _root;
    private final boolean _enabled;

    private static URL toURL(String root) {
        try {
            return root == null ? null : new URL(root);
        }
        catch (MalformedURLException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    public RemoteHostResourceMount(String root) throws WicketRuntimeException {
        this(RemoteHostResourceMount.toURL(root), true);
    }

    public RemoteHostResourceMount(String root, boolean enabled) throws WicketRuntimeException {
        this(RemoteHostResourceMount.toURL(root), enabled);
    }

    public RemoteHostResourceMount(URL root) {
        this(root, true);
    }

    public RemoteHostResourceMount(URL root, boolean enabled) {
        this._enabled = enabled;
        this._root = root;
    }

    @Override
    protected IRequestTargetUrlCodingStrategy newStrategy(String mountPath, final ResourceReference ref, final boolean merge) {
        if (!this._enabled) {
            return super.newStrategy(mountPath, ref, merge);
        }
        return new RemoteHostUrlCodingStrategy(this._root, mountPath, ref){

            protected SharedResourceRequestTargetUrlCodingStrategy newStrategy(String mountPath, String sharedResourceKey) {
                return (SharedResourceRequestTargetUrlCodingStrategy)RemoteHostResourceMount.super.newStrategy(mountPath, ref, merge);
            }
        };
    }
}

