/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;
import java.util.Locale;
import org.apache.wicket.IClusterable;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.string.Strings;

public class ResourceSpec
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final String _scopeName;
    @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="set from scopeName on demand")
    private transient Class<?> _scope;
    private final String _file;
    private final ResourceReference _ref;
    private final Locale _locale;
    private final String _style;
    private final Integer _cacheDuration;

    public static ResourceSpec[] toResourceSpecs(Class<?>[] scopes, String[] files) {
        if (scopes.length != files.length) {
            throw new IllegalArgumentException("arrays must be of equal length: " + Arrays.toString(scopes) + ", " + Arrays.toString(files));
        }
        ResourceSpec[] resourceSpecs = new ResourceSpec[scopes.length];
        for (int i = 0; i < scopes.length; ++i) {
            resourceSpecs[i] = new ResourceSpec(scopes[i], files[i]);
        }
        return resourceSpecs;
    }

    public static Class<?>[] toScopes(ResourceSpec[] specs) {
        Class[] scopes = new Class[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            scopes[i] = specs[i].getScope();
        }
        return scopes;
    }

    public static String[] toFiles(ResourceSpec[] specs) {
        String[] files = new String[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            files[i] = specs[i].getFile();
        }
        return files;
    }

    public ResourceSpec(Class<?> scope, String file) {
        this(scope, file, null, null, null, null);
    }

    public ResourceSpec(Class<?> scope, String file, Locale locale) {
        this(scope, file, locale, null, null, null);
    }

    public ResourceSpec(Class<?> scope, String file, String style) {
        this(scope, file, null, style, null, null);
    }

    public ResourceSpec(Class<?> scope, String file, Locale locale, String style) {
        this(scope, file, locale, style, null, null);
    }

    public ResourceSpec(Class<?> scope, String file, Integer cacheDuration) {
        this(scope, file, null, null, cacheDuration, null);
    }

    public ResourceSpec(Class<?> scope, String file, Locale locale, Integer cacheDuration) {
        this(scope, file, locale, null, cacheDuration, null);
    }

    public ResourceSpec(Class<?> scope, String file, String style, Integer cacheDuration) {
        this(scope, file, null, style, cacheDuration, null);
    }

    public ResourceSpec(Class<?> scope, String file, Locale locale, String style, Integer cacheDuration) {
        this(scope, file, locale, style, cacheDuration, null);
    }

    public ResourceSpec(ResourceReference ref) {
        this(ref.getScope(), ref.getName(), ref.getLocale(), ref.getStyle(), null, ref);
    }

    private ResourceSpec(Class<?> scope, String file, Locale locale, String style, Integer cacheDuration, ResourceReference ref) {
        if (scope == null) {
            throw new NullPointerException("scope");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (file.startsWith("/")) {
            throw new IllegalArgumentException("file must not start with '/', was '" + file + "'");
        }
        if (Strings.isEmpty((CharSequence)file)) {
            throw new IllegalArgumentException("file must not be empty");
        }
        this._scope = scope;
        this._scopeName = this._scope.getName();
        this._file = file;
        this._locale = locale;
        this._style = style;
        this._cacheDuration = cacheDuration;
        this._ref = ref;
    }

    public Class<?> getScope() {
        if (this._scope == null) {
            try {
                this._scope = Class.forName(this._scopeName);
            }
            catch (ClassNotFoundException e) {
                throw new WicketRuntimeException("failed to get scope class by name", (Throwable)e);
            }
        }
        return this._scope;
    }

    public String getFile() {
        return this._file;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String getStyle() {
        return this._style;
    }

    public Integer getCacheDuration() {
        return this._cacheDuration;
    }

    public ResourceReference getRef() {
        return this._ref;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._file.hashCode();
        result = 31 * result + this._scopeName.hashCode();
        result = 31 * result + (this._locale == null ? 0 : this._locale.hashCode());
        result = 31 * result + (this._style == null ? 0 : this._style.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSpec)) {
            return false;
        }
        ResourceSpec other = (ResourceSpec)obj;
        if (!this._file.equals(other._file)) {
            return false;
        }
        if (!this._scopeName.equals(other._scopeName)) {
            return false;
        }
        if (this._locale == null ? other._locale != null : !this._locale.equals(other._locale)) {
            return false;
        }
        return !(this._style == null ? other._style != null : !this._style.equals(other._style));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceSpec [");
        if (this._ref != null) {
            builder.append("ref=").append(this._ref);
        } else {
            builder.append("file=").append(this._file).append(", ");
            builder.append("scopeName=").append(this._scopeName).append(", ");
            if (this._locale != null) {
                builder.append("locale=").append(this._locale).append(", ");
            }
            if (this._style != null) {
                builder.append("style=").append(this._style).append(", ");
            }
            if (this._cacheDuration != null) {
                builder.append("cacheDuration=").append(this._cacheDuration).append(", ");
            }
            builder.setLength(builder.length() - 2);
            builder.append("]");
        }
        return builder.toString();
    }
}

