/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.util;

import at.molindo.thirdparty.com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YuiCompressorUtil {
    private static final transient Logger log = LoggerFactory.getLogger(YuiCompressorUtil.class);

    private YuiCompressorUtil() {
    }

    public static String compress(String toCompress) {
        StringWriter writer = new StringWriter((int)((double)toCompress.length() * 0.8));
        try {
            new CssCompressor(new StringReader(toCompress)).compress(writer, 0);
        }
        catch (Exception e) {
            log.warn("Could not compress merged CSS stream, using uncompressed content", (Throwable)e);
            return toCompress;
        }
        return writer.toString();
    }

    public static byte[] compress(byte[] toCompress, Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(toCompress.length);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            new CssCompressor(new InputStreamReader((InputStream)new ByteArrayInputStream(toCompress), charset)).compress(writer, 0);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            log.warn("Could not compress merged CSS stream, using uncompressed content", (Throwable)e);
            return toCompress;
        }
        return out.toByteArray();
    }
}

