/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.urlcoding;

import at.molindo.utils.data.StringUtils;
import at.molindo.wicketutils.utils.WicketUtils;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.coding.AbstractRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.coding.IMountableRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.coding.IRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.coding.SharedResourceRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.resource.SharedResourceRequestTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteHostUrlCodingStrategy
implements IRequestTargetUrlCodingStrategy,
IMountableRequestTargetUrlCodingStrategy {
    private static final Logger log = LoggerFactory.getLogger(RemoteHostUrlCodingStrategy.class);
    private final AbstractRequestTargetUrlCodingStrategy _strategy;
    private final String _key;
    private final String _protocol;
    private final Integer _port;
    private final String _host;
    private final String _path;
    private boolean _useRequestProtocol = true;
    private boolean _useRequestPort = true;

    public RemoteHostUrlCodingStrategy(URL root, String mountPath, ResourceReference ref) {
        if (ref == null) {
            throw new NullPointerException("sharedResourceKey");
        }
        this._key = ref.getSharedResourceKey();
        this._strategy = this.newStrategy(mountPath, this._key);
        if (root != null) {
            this._protocol = root.getProtocol();
            this._port = root.getPort();
            this._host = root.getHost();
            this._path = StringUtils.trailing((String)root.getFile(), (String)"/");
        } else {
            this._port = null;
            this._path = null;
            this._protocol = null;
            this._host = null;
        }
    }

    protected AbstractRequestTargetUrlCodingStrategy newStrategy(String mountPath, String sharedResourceKey) {
        return new SharedResourceRequestTargetUrlCodingStrategy(mountPath, sharedResourceKey);
    }

    public IRequestTarget decode(final RequestParameters requestParameters) {
        return new IRequestTarget(){
            private SharedResourceRequestTarget _orig;

            private SharedResourceRequestTarget getOriginalRequestTarget() {
                if (this._orig == null) {
                    this._orig = (SharedResourceRequestTarget)RemoteHostUrlCodingStrategy.this._strategy.decode(requestParameters);
                }
                return this._orig;
            }

            public void detach(RequestCycle requestCycle) {
                if (this._orig != null) {
                    this._orig.detach(requestCycle);
                }
            }

            public void respond(RequestCycle requestCycle) {
                this.getOriginalRequestTarget().respond(requestCycle);
            }
        };
    }

    public CharSequence encode(IRequestTarget requestTarget) {
        CharSequence encoded = this._strategy.encode(requestTarget);
        if (this._host == null) {
            return encoded;
        }
        String protocol = !this.isUseRequestProtocol() ? this._protocol : WicketUtils.getHttpServletRequest().getScheme();
        Integer port = !this.isUseRequestPort() ? this._port.intValue() : WicketUtils.getHttpServletRequest().getServerPort();
        if (port != null) {
            if (port == 80 && "http".equals(protocol)) {
                port = null;
            } else if (port == 443 && "https".equals(protocol)) {
                port = null;
            }
        }
        try {
            return new URL(protocol, this._host, port == null ? -1 : port, this._path + StringUtils.stripLeading((String)((Object)encoded).toString(), (String)"/")).toString();
        }
        catch (MalformedURLException e) {
            log.error("failed to build URL, balling back to default", (Throwable)e);
            return encoded;
        }
    }

    public String getMountPath() {
        return this._strategy.getMountPath();
    }

    public boolean matches(IRequestTarget requestTarget) {
        return this._strategy.matches(requestTarget);
    }

    public boolean matches(String path, boolean b) {
        return this._strategy.matches(path, b);
    }

    public boolean isUseRequestProtocol() {
        return this._useRequestProtocol;
    }

    public RemoteHostUrlCodingStrategy setUseRequestProtocol(boolean useRequestProtocol) {
        this._useRequestProtocol = useRequestProtocol;
        return this;
    }

    public boolean isUseRequestPort() {
        return this._useRequestPort;
    }

    public RemoteHostUrlCodingStrategy setUseRequestPort(boolean useRequestPort) {
        this._useRequestPort = useRequestPort;
        return this;
    }
}

