/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.resources;

import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.markup.html.CompressedPackageResource;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.util.resource.IResourceStream;
import org.wicketstuff.mergedresources.ResourceSpec;
import org.wicketstuff.mergedresources.preprocess.IResourcePreProcessor;
import org.wicketstuff.mergedresources.resources.MergedResourceStream;

public class CompressedMergedResource
extends CompressedPackageResource {
    private static final long serialVersionUID = 1L;
    private final IResourceStream _mergedResourceStream;
    private int _cacheDuration;

    @Deprecated
    public CompressedMergedResource(Class<?> scope, String path, Locale locale, String style, Class<?>[] scopes, String[] files, int cacheDuration) {
        this(scope, path, locale, style, ResourceSpec.toResourceSpecs(scopes, files), cacheDuration, null);
    }

    public CompressedMergedResource(Class<?> scope, String path, Locale locale, String style, ResourceSpec[] specs, int cacheDuration, IResourcePreProcessor preProcessor) {
        super(scope, path, locale, style);
        this._cacheDuration = cacheDuration;
        this._mergedResourceStream = this.newResourceStream(locale, style, specs, preProcessor);
    }

    protected IResourceStream newResourceStream(Locale locale, String style, ResourceSpec[] specs, IResourcePreProcessor preProcessor) {
        return new MergedResourceStream(specs, locale, style, preProcessor);
    }

    protected IResourceStream getPackageResourceStream() {
        return this._mergedResourceStream;
    }

    public int getCacheDuration() {
        return this._cacheDuration;
    }

    protected void setHeaders(WebResponse response) {
        super.setHeaders(response);
        if (!Application.get().getResourceSettings().getDisableGZipCompression()) {
            response.setHeader("Vary", "Accept-Encoding");
        }
        response.setHeader("Cache-control", "public");
    }
}

