/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.resources;

import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.javascript.IJavascriptCompressor;
import org.apache.wicket.util.resource.IResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.mergedresources.ResourceSpec;
import org.wicketstuff.mergedresources.preprocess.IResourcePreProcessor;
import org.wicketstuff.mergedresources.resources.CompressedMergedResource;
import org.wicketstuff.mergedresources.resources.MergedResourceStream;

public class CompressedMergedJsResource
extends CompressedMergedResource {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(CompressedMergedJsResource.class);

    @Deprecated
    public CompressedMergedJsResource(Class<?> scope, String path, Locale locale, String style, Class<?>[] scopes, String[] files, int cacheDuration) {
        this(scope, path, locale, style, ResourceSpec.toResourceSpecs(scopes, files), cacheDuration, null);
    }

    public CompressedMergedJsResource(Class<?> scope, String path, Locale locale, String style, ResourceSpec[] specs, int cacheDuration, IResourcePreProcessor preProcessor) {
        super(scope, path, locale, style, specs, cacheDuration, preProcessor);
    }

    @Override
    protected IResourceStream newResourceStream(Locale locale, String style, ResourceSpec[] specs, IResourcePreProcessor preProcessor) {
        return new MergedResourceStream(specs, locale, style, preProcessor){
            private static final long serialVersionUID = 1L;

            @Override
            protected byte[] toContent(byte[] content) {
                try {
                    IJavascriptCompressor compressor = Application.get().getResourceSettings().getJavascriptCompressor();
                    if (compressor != null) {
                        return compressor.compress(new String(content)).getBytes();
                    }
                    return content;
                }
                catch (Exception e) {
                    log.error("Error while stripping content", (Throwable)e);
                    return content;
                }
            }

            @Override
            public String getContentType() {
                return "application/x-javascript";
            }
        };
    }
}

