/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mergedresources.annotations;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.config.MatchingResources;
import org.wicketstuff.mergedresources.ResourceSpec;
import org.wicketstuff.mergedresources.annotations.CssContribution;
import org.wicketstuff.mergedresources.annotations.CssContributions;
import org.wicketstuff.mergedresources.annotations.JsContribution;
import org.wicketstuff.mergedresources.annotations.ResourceContribution;

public class ContributionScanner {
    private static final String DEFAULT_PATH_JS = "all.js";
    private static final String DEFAULT_PATH_CSS = "all.css";
    private final Map<String, SortedSet<WeightedResourceSpec>> _contributions;

    public ContributionScanner(String packageName) {
        MatchingResources resources = new MatchingResources(this.getPatternForPackage(packageName));
        this._contributions = this.scan(resources);
    }

    private Map<String, SortedSet<WeightedResourceSpec>> scan(MatchingResources resources) {
        Annotation a;
        HashMap<String, SortedSet<WeightedResourceSpec>> contributions = new HashMap<String, SortedSet<WeightedResourceSpec>>();
        for (Class clazz : resources.getAnnotatedMatches(JsContribution.class)) {
            a = clazz.getAnnotation(JsContribution.class);
            this.addJsContributions(clazz, (JsContribution)a, (Map<String, SortedSet<WeightedResourceSpec>>)contributions);
        }
        for (Class clazz : resources.getAnnotatedMatches(CssContribution.class)) {
            a = clazz.getAnnotation(CssContribution.class);
            this.addCssContributions(clazz, (CssContribution)a, contributions);
        }
        for (Class clazz : resources.getAnnotatedMatches(CssContributions.class)) {
            CssContributions cssMulti = clazz.getAnnotation(CssContributions.class);
            for (CssContribution css : cssMulti.value()) {
                this.addCssContributions(clazz, css, contributions);
            }
        }
        for (Class clazz : resources.getAnnotatedMatches(ResourceContribution.class)) {
            ResourceContribution resource = clazz.getAnnotation(ResourceContribution.class);
            this.addResourceContributions(clazz, resource, contributions);
        }
        for (Map.Entry entry : contributions.entrySet()) {
            entry.setValue(Collections.unmodifiableSortedSet((SortedSet)entry.getValue()));
        }
        return Collections.unmodifiableMap(contributions);
    }

    private void addJsContributions(Class<?> scope, JsContribution js, Map<String, SortedSet<WeightedResourceSpec>> contributions) {
        for (String file : js.value()) {
            String path;
            SortedSet<WeightedResourceSpec> specs;
            if (Strings.isEmpty((CharSequence)file)) {
                file = scope.getSimpleName() + ".js";
            }
            if ((specs = contributions.get(path = Strings.isEmpty((CharSequence)js.path()) ? DEFAULT_PATH_JS : js.path())) == null) {
                specs = new TreeSet<WeightedResourceSpec>(WeightedResourceSpecComparator.INSTANCE);
                contributions.put(path, specs);
            }
            if (specs.add(new WeightedResourceSpec(scope, file, js.order()))) continue;
            throw new WicketRuntimeException("duplicate resource contribution: " + js + ", scope=" + scope);
        }
    }

    private void addCssContributions(Class<?> scope, CssContribution css, Map<String, SortedSet<WeightedResourceSpec>> contributions) {
        for (String file : css.value()) {
            String path;
            SortedSet<WeightedResourceSpec> specs;
            if (Strings.isEmpty((CharSequence)file)) {
                file = ContributionScanner.getDefaultCssFile(scope.getSimpleName(), css.media());
            }
            if ((specs = contributions.get(path = Strings.isEmpty((CharSequence)css.path()) ? ContributionScanner.getDefaultCssPath(css.media()) : css.path())) == null) {
                specs = new TreeSet<WeightedResourceSpec>(WeightedResourceSpecComparator.INSTANCE);
                contributions.put(path, specs);
            }
            if (specs.add(new WeightedResourceSpec(scope, file, css.order()))) continue;
            throw new WicketRuntimeException("duplicate resource contribution: " + css + ", scope=" + scope);
        }
    }

    static String getDefaultCssFile(String simpleName, String media) {
        if (!Strings.isEmpty((CharSequence)media) && !"all".equals(media)) {
            return simpleName + "-" + media + ".css";
        }
        return simpleName + ".css";
    }

    static String getDefaultCssPath(String media) {
        if (!Strings.isEmpty((CharSequence)media)) {
            return media + ".css";
        }
        return DEFAULT_PATH_CSS;
    }

    private void addResourceContributions(Class<?> scope, ResourceContribution resource, Map<String, SortedSet<WeightedResourceSpec>> contributions) {
        for (String file : resource.value()) {
            if (Strings.isEmpty((CharSequence)file)) {
                throw new WicketRuntimeException("empty file name not allowed for @ResourceContributions at class " + scope.getName());
            }
            String path = Strings.isEmpty((CharSequence)resource.path()) ? file : resource.path();
            SortedSet<WeightedResourceSpec> specs = contributions.get(path);
            if (specs == null) {
                specs = new TreeSet<WeightedResourceSpec>(WeightedResourceSpecComparator.INSTANCE);
                contributions.put(path, specs);
            }
            if (specs.add(new WeightedResourceSpec(scope, file))) continue;
            throw new WicketRuntimeException("duplicate resource contribution: " + resource + ", scope=" + scope);
        }
    }

    public Map<String, SortedSet<WeightedResourceSpec>> getContributions() {
        return this._contributions;
    }

    private String getPatternForPackage(String packageName) {
        if (packageName == null) {
            packageName = "";
        }
        if (!(packageName = packageName.replace('.', '/')).endsWith("/")) {
            packageName = packageName + '/';
        }
        return "classpath*:" + packageName + "**/*.class";
    }

    public static enum WeightedResourceSpecComparator implements Comparator<WeightedResourceSpec>
    {
        INSTANCE;


        @Override
        public int compare(WeightedResourceSpec o1, WeightedResourceSpec o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            int val = Integer.valueOf(o2._weight).compareTo(o1._weight);
            if (val != 0) {
                return val;
            }
            val = o1.getFile().compareTo(o2.getFile());
            if (val != 0) {
                return val;
            }
            return o1.getScope().getName().compareTo(o2.getScope().getName());
        }
    }

    @SuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="super type is sufficient, ignore weight")
    public static final class WeightedResourceSpec
    extends ResourceSpec {
        private static final long serialVersionUID = 1L;
        private final int _weight;

        public WeightedResourceSpec(Class<?> scope, String file, int weight) {
            super(scope, file);
            this._weight = weight;
        }

        public WeightedResourceSpec(Class<?> scope, String file) {
            this(scope, file, 0);
        }

        @Override
        public String toString() {
            return super.toString() + " (weight=" + this._weight + ")";
        }
    }
}

