/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.custom.repository.support;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import lombok.NonNull;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.data.custom.repository.support.CustomQueryLookupStrategy;
import org.springframework.data.custom.repository.support.SimpleCustomRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReflectionEntityInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;

public class CustomRepositoryFactorySupport
extends RepositoryFactorySupport {
    @NonNull
    private final ApplicationContext applicationContext;

    public <T, ID extends Serializable> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return new ReflectionEntityInformation(domainClass);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        return BeanUtils.instantiate((Class)metadata.getRepositoryBaseClass());
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleCustomRepository.class;
    }

    public <T> T getRepository(Class<T> repositoryInterface, Object customImplementation) {
        return (T)super.getRepository(repositoryInterface, customImplementation);
    }

    protected CustomQueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return new CustomQueryLookupStrategy(this.applicationContext);
    }

    @ConstructorProperties(value={"applicationContext"})
    public CustomRepositoryFactorySupport(@NonNull ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new NullPointerException("applicationContext");
        }
        this.applicationContext = applicationContext;
    }
}

