/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.openid.security;

import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.social.openid.security.IRealmMapper;

public class WildcardRealmMapper
implements IRealmMapper {
    private static final Logger log = LoggerFactory.getLogger(WildcardRealmMapper.class);

    @Override
    public String getMapping(String returnToUrl) {
        try {
            URL url = new URL(returnToUrl);
            StringBuilder buf = new StringBuilder();
            buf.append(url.getProtocol()).append("://");
            String[] hostParts = url.getHost().split("\\.");
            if (hostParts.length <= 2) {
                buf.append(url.getHost());
            } else {
                buf.append("*.").append(hostParts[hostParts.length - 2]).append(".").append(hostParts[hostParts.length - 1]);
            }
            if (url.getPort() != -1) {
                buf.append(":").append(url.getPort());
            }
            buf.append("/");
            return buf.toString();
        }
        catch (MalformedURLException e) {
            log.warn("returnToUrl not a valid URL", (Throwable)e);
            return null;
        }
    }
}

