/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.openid.connect;

import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.support.AbstractConnection;
import org.springframework.social.openid.api.OpenId;
import org.springframework.social.openid.connect.OpenIdServiceProvider;

public class OpenIdConnection
extends AbstractConnection<OpenId> {
    private final OpenIdServiceProvider serviceProvider;
    private final OpenId api;

    public OpenIdConnection(String verifiedOpenId, OpenIdServiceProvider serviceProvider, ApiAdapter<OpenId> apiAdapter) {
        super(apiAdapter);
        this.serviceProvider = serviceProvider;
        this.api = this.initApi(verifiedOpenId);
    }

    public OpenIdConnection(ConnectionData data, OpenIdServiceProvider serviceProvider, ApiAdapter<OpenId> apiAdapter) {
        super(data, apiAdapter);
        this.serviceProvider = serviceProvider;
        this.api = this.initApi(data.getProviderUserId());
    }

    private OpenId initApi(String verifiedOpenId) {
        return this.serviceProvider.getApi(verifiedOpenId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenId getApi() {
        Object object = this.getMonitor();
        synchronized (object) {
            return this.api;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionData createData() {
        Object object = this.getMonitor();
        synchronized (object) {
            return new ConnectionData(this.getKey().getProviderId(), this.getKey().getProviderUserId(), this.getDisplayName(), this.getProfileUrl(), this.getImageUrl(), null, null, null, null);
        }
    }
}

