/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.wicketutils.migration;

import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.UrlDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WicketURLDecoder {
    QUERY_INSTANCE(UrlDecoder.QUERY_INSTANCE),
    PATH_INSTANCE(UrlDecoder.PATH_INSTANCE);

    private static final Logger log;
    private final UrlDecoder _decoder;

    private WicketURLDecoder(UrlDecoder decoder) {
        if (decoder == null) {
            throw new NullPointerException("decoder");
        }
        this._decoder = decoder;
    }

    public String decode(String s) {
        Application app = null;
        try {
            app = Application.get();
        }
        catch (WicketRuntimeException ignored) {
            log.warn("No current Application found - defaulting encoding to UTF-8");
        }
        return this.decode(s, app == null ? "UTF-8" : app.getRequestCycleSettings().getResponseRequestEncoding());
    }

    private String decode(String s, String enc) {
        return this._decoder.decode(s, enc);
    }

    static {
        log = LoggerFactory.getLogger(WicketURLDecoder.class);
    }
}

