/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.wicketutils.utils;

import javax.annotation.Nonnull;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.WicketRuntimeException;

public abstract class PageSpec {
    private final boolean _bookmarkable;

    public static PageSpec get(final Page page) {
        return new PageSpec(false){

            @Override
            protected void setResponsePage(RequestCycle rc) {
                rc.setResponsePage(page);
            }
        };
    }

    public static PageSpec get(Class<? extends Page> pageClass) {
        return PageSpec.get(pageClass, null, null);
    }

    public static PageSpec get(Class<? extends Page> pageClass, PageParameters params) {
        return PageSpec.get(pageClass, params, null);
    }

    public static PageSpec get(final Class<? extends Page> pageClass, final PageParameters params, final String pageMapName) {
        return new PageSpec(true){

            @Override
            protected void setResponsePage(RequestCycle rc) {
                if (pageMapName == null) {
                    rc.setResponsePage(pageClass, params);
                } else {
                    rc.setResponsePage(pageClass, params, pageMapName);
                }
            }
        };
    }

    private PageSpec(boolean bookmarkable) {
        this._bookmarkable = bookmarkable;
    }

    public boolean isBookmarkable() {
        return this._bookmarkable;
    }

    public void setAsResponsePage(boolean redirect) {
        RequestCycle rc = RequestCycle.get();
        if (rc == null) {
            throw new WicketRuntimeException("no request cycle available");
        }
        this.setAsResponsePage(rc, redirect);
    }

    public void setAsResponsePage(@Nonnull RequestCycle rc, boolean redirect) {
        if (rc == null) {
            throw new NullPointerException("rc");
        }
        this.setResponsePage(rc);
        rc.setRedirect(true);
    }

    protected abstract void setResponsePage(@Nonnull RequestCycle var1);
}

