/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.wicketutils.utils;

import at.molindo.wicketutils.utils.IMockRequestCallback;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.wicket.Application;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.IWebApplicationFactory;
import org.apache.wicket.protocol.http.MockHttpServletRequest;
import org.apache.wicket.protocol.http.MockHttpServletResponse;
import org.apache.wicket.protocol.http.MockHttpSession;
import org.apache.wicket.protocol.http.MockServletContext;
import org.apache.wicket.protocol.http.VisibilityHelper;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.WicketFilter;

public class MockUtils {
    private MockUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V withNewRequest(WebApplication webApplication, IMockRequestCallback<V> callback) {
        Session oldSession = Session.exists() ? Session.get() : null;
        RequestCycle oldRequestCycle = RequestCycle.get();
        try {
            if (oldSession != null) {
                Session.unset();
            }
            if (oldRequestCycle != null) {
                org.apache.wicket.VisibilityHelper.set(null);
            }
            V v = MockUtils.withRequest(webApplication, callback);
            return v;
        }
        finally {
            if (oldSession != null) {
                Session.set((Session)oldSession);
            }
            if (oldRequestCycle != null) {
                org.apache.wicket.VisibilityHelper.set(oldRequestCycle);
            }
        }
    }

    public static <V> V withRequest(String applicationKey, IMockRequestCallback<V> callback) {
        return MockUtils.withRequest((WebApplication)Application.get((String)applicationKey), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V withRequest(WebApplication webApplication, IMockRequestCallback<V> callback) {
        Application prevApplication = null;
        boolean setupSession = !Session.exists();
        WebRequestCycle requestCycle = null;
        try {
            if (setupSession) {
                if (Application.exists()) {
                    prevApplication = Application.get();
                }
                Application.set((Application)webApplication);
                ServletContext context = webApplication.getServletContext();
                MockHttpSession httpSession = new MockHttpSession(context);
                MockServletRequest servletRequest = new MockServletRequest((Application)webApplication, (HttpSession)httpSession, context);
                callback.configure(new IMockRequestCallback.MockRequest(servletRequest));
                servletRequest.setDefaultHeaders();
                MockServletResponse servletResponse = new MockServletResponse(servletRequest);
                WebRequest request = VisibilityHelper.newWebRequest(webApplication, (HttpServletRequest)servletRequest);
                WebResponse response = VisibilityHelper.newWebResponse(webApplication, (HttpServletResponse)servletResponse);
                requestCycle = (WebRequestCycle)webApplication.newRequestCycle((Request)request, (Response)response);
                Session.findOrCreate((Request)request, (Response)response);
            }
            V v = callback.call();
            return v;
        }
        finally {
            if (setupSession) {
                if (requestCycle != null) {
                    VisibilityHelper.unset(requestCycle);
                }
                Session.unset();
                if (prevApplication != null) {
                    Application.set((Application)prevApplication);
                } else {
                    Application.unset();
                }
            }
        }
    }

    public static WicketFilter newMockFilter(final WebApplication application) {
        final MockServletContext context = new MockServletContext((Application)application, "/");
        WicketFilter filter = new WicketFilter(){

            protected IWebApplicationFactory getApplicationFactory() {
                return new IWebApplicationFactory(){

                    public WebApplication createApplication(WicketFilter filter) {
                        return application;
                    }
                };
            }
        };
        try {
            filter.init(new FilterConfig(){

                public ServletContext getServletContext() {
                    return context;
                }

                public Enumeration<?> getInitParameterNames() {
                    return null;
                }

                public String getInitParameter(String name) {
                    return null;
                }

                public String getFilterName() {
                    return "WicketMockServlet";
                }
            });
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        return filter;
    }

    public static class MockServletResponse
    extends MockHttpServletResponse {
        public MockServletResponse(MockServletRequest request) {
            super((MockHttpServletRequest)request);
        }
    }

    public static final class MockServletRequest
    extends MockHttpServletRequest {
        private boolean _initialized = true;
        private String _scheme = "http";
        private String _serverName = "localhost";
        private int _serverPort = 80;

        private MockServletRequest(Application application, HttpSession session, ServletContext context) {
            super(application, session, context);
        }

        public void addHeader(String name, String value) {
            if (this._initialized) {
                super.addHeader(name, value);
            }
        }

        public void setScheme(String scheme) {
            this._scheme = scheme;
        }

        public String getScheme() {
            return this._scheme;
        }

        public void setServerName(String serverName) {
            this._serverName = serverName;
        }

        public String getServerName() {
            return this._serverName;
        }

        public void setServerPort(int serverPort) {
            this._serverPort = serverPort;
        }

        public int getServerPort() {
            return this._serverPort;
        }

        public boolean isSecure() {
            return "https".equals(this.getScheme());
        }

        public StringBuffer getRequestURL() {
            String query;
            StringBuffer buf = new StringBuffer();
            buf.append(this.getScheme()).append("://").append(this.getServerName());
            if (!("http".equals(this.getScheme()) && this.getServerPort() == 80 || "https".equals(this.getScheme()) && this.getServerPort() == 443)) {
                buf.append(":").append(this.getServerPort());
            }
            buf.append(this.getContextPath());
            if (this.getPathInfo() != null) {
                buf.append(this.getPathInfo());
            }
            if ((query = this.getQueryString()) != null) {
                buf.append('?');
                buf.append(query);
            }
            return buf;
        }

        private void setDefaultHeaders() {
            if (this.getHeader("Accept") == null) {
                this.addHeader("Accept", "text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
            }
            if (this.getHeader("Accept-Charset") == null) {
                this.addHeader("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
            }
            if (this.getHeader("Accept-Language") == null) {
                Locale l = Locale.getDefault();
                this.addHeader("Accept-Language", l.getLanguage().toLowerCase() + "-" + l.getCountry().toLowerCase() + "," + l.getLanguage().toLowerCase() + ";q=0.5");
            }
            if (this.getHeader("User-Agent") == null) {
                this.addHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:1.7) Gecko/20040707 Firefox/0.9.2");
            }
        }
    }
}

