/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.wicketutils.dev;

import java.lang.reflect.Field;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainerWithAssociatedMarkup;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.resource.IResourceStream;

public final class MarkupSourceAttributeAppender
implements IComponentInstantiationListener {
    private final String attribute;

    public MarkupSourceAttributeAppender(String attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        this.attribute = attribute;
    }

    public void onInstantiation(Component component) {
        if (component instanceof WebMarkupContainerWithAssociatedMarkup) {
            component.add(new IBehavior[]{new AttributeModifier(this.attribute, true, (IModel)new MarkupSourceModel((WebMarkupContainerWithAssociatedMarkup)component))});
        }
    }

    private static final class MarkupSourceModel
    extends LoadableDetachableModel<CharSequence> {
        private static final long serialVersionUID = 1L;
        private final WebMarkupContainerWithAssociatedMarkup component;

        private MarkupSourceModel(WebMarkupContainerWithAssociatedMarkup component) {
            this.component = component;
        }

        protected CharSequence load() {
            MarkupStream stream = this.component.getAssociatedMarkupStream(false);
            if (stream == null || stream.getResource() == null) {
                return "VA_REMOVE";
            }
            String resource = this.toString(stream.getResource());
            if (this.component instanceof Fragment) {
                resource = resource + " [wicket:fragment=" + this.getFragmentId((Fragment)this.component) + "]";
            }
            return resource;
        }

        private String getFragmentId(Fragment fragment) {
            try {
                Field field = Fragment.class.getDeclaredField("markupId");
                field.setAccessible(true);
                return (String)field.get(fragment);
            }
            catch (NoSuchFieldException e) {
                throw new WicketRuntimeException("field 'markupId' of Fragment doesn't exist", (Throwable)e);
            }
            catch (Exception e) {
                return "<unknown>";
            }
        }

        private String toString(IResourceStream resource) {
            return resource.toString();
        }
    }
}

