/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.wicketutils.utils;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.NotImplementedException;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.protocol.http.servlet.AbortWithHttpStatusException;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.util.value.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WicketUtils {
    private static final Logger log = LoggerFactory.getLogger(WicketUtils.class);

    private WicketUtils() {
    }

    public static Class<? extends Page> getBookmarkablePage(RequestCycle cycle) {
        if (cycle == null) {
            return null;
        }
        IRequestTarget target = cycle.getRequestTarget();
        if (target instanceof BookmarkablePageRequestTarget) {
            return ((BookmarkablePageRequestTarget)target).getPageClass();
        }
        return null;
    }

    public static boolean isBookmarkableRequest(URL url) {
        IRequestTarget rt = WicketUtils.getRequestTarget(url);
        return rt instanceof IBookmarkablePageRequestTarget;
    }

    public static Class<? extends Page> getBookmarkablePage(URL url) {
        IRequestTarget rt = WicketUtils.getRequestTarget(url);
        if (rt instanceof IBookmarkablePageRequestTarget) {
            IBookmarkablePageRequestTarget target = (IBookmarkablePageRequestTarget)rt;
            return target.getPageClass();
        }
        return null;
    }

    public static IBookmarkablePageRequestTarget getBookmarkableRequestTarget(URL url) {
        IRequestTarget rt = WicketUtils.getRequestTarget(url);
        if (rt instanceof IBookmarkablePageRequestTarget) {
            return (IBookmarkablePageRequestTarget)rt;
        }
        return null;
    }

    public static IRequestTarget getRequestTarget(URL url) {
        if (url != null) {
            RequestCycle rc = RequestCycle.get();
            IRequestCycleProcessor processor = rc.getProcessor();
            RequestParameters requestParameters = processor.getRequestCodingStrategy().decode((Request)new UrlRequest(rc.getRequest(), url));
            try {
                return processor.resolve(rc, requestParameters);
            }
            catch (WicketRuntimeException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static AbstractLink getBookmarkableRefererLink(String id, IModel<String> labelModel) {
        String referer = WicketUtils.getReferer();
        if (referer == null) {
            return null;
        }
        try {
            if (WicketUtils.isBookmarkableRequest(new URL(referer))) {
                return new ExternalLink(id, (IModel)new Model((Serializable)((Object)referer)), labelModel);
            }
        }
        catch (MalformedURLException e) {
            log.warn("malformed referer url: " + referer + " (" + e.toString() + ")");
        }
        return null;
    }

    public static String getReferer() {
        return WicketUtils.getHttpServletRequest().getHeader("Referer");
    }

    public static String getRequested() {
        String query;
        HttpServletRequest req = WicketUtils.getHttpServletRequest();
        StringBuilder buf = new StringBuilder();
        buf.append(req.getServletPath());
        String path = req.getPathInfo();
        if (path != null) {
            buf.append(path);
        }
        if ((query = req.getQueryString()) != null) {
            buf.append("?").append(query);
        }
        return buf.toString();
    }

    public static HttpServletRequest getHttpServletRequest() {
        WebRequest wr = WicketUtils.getWebRequest();
        return wr == null ? null : wr.getHttpServletRequest();
    }

    public static HttpServletResponse getHttpServletResponse() {
        WebResponse wr = WicketUtils.getWebResponse();
        return wr == null ? null : wr.getHttpServletResponse();
    }

    public static String getRemoteAddr() {
        return WicketUtils.getHttpServletRequest().getRemoteAddr();
    }

    public static String getRequestParameter(String name) {
        return WicketUtils.getHttpServletRequest().getParameter(name);
    }

    public static Request getRequest() {
        RequestCycle rc = RequestCycle.get();
        return rc == null ? null : rc.getRequest();
    }

    public static WebRequest getWebRequest() {
        Request request = WicketUtils.getRequest();
        return request instanceof WebRequest ? (WebRequest)request : null;
    }

    public static WebRequestCycle getWebRequestCycle() {
        RequestCycle rc = RequestCycle.get();
        return rc instanceof WebRequestCycle ? (WebRequestCycle)rc : null;
    }

    public static Response getResponse() {
        RequestCycle rc = RequestCycle.get();
        return rc == null ? null : rc.getResponse();
    }

    public static WebResponse getWebResponse() {
        Response response = WicketUtils.getResponse();
        return response instanceof WebResponse ? (WebResponse)response : null;
    }

    public static boolean isHttps() {
        return "https".equalsIgnoreCase(WicketUtils.getHttpServletRequest().getScheme());
    }

    public static Cookie getCookie(String name) {
        Cookie[] cookies = WicketUtils.getHttpServletRequest().getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie c : cookies) {
            if (!name.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    public static void deleteCookie(String name) {
        Cookie c = new Cookie(name, "");
        c.setMaxAge(0);
        WicketUtils.getHttpServletResponse().addCookie(c);
    }

    public static String getHeader(String name) {
        HttpServletRequest r = WicketUtils.getHttpServletRequest();
        return r == null ? null : r.getHeader(name);
    }

    public static WebClientInfo getClientInfo() {
        return (WebClientInfo)Session.get().getClientInfo();
    }

    public static String getUserAgent() {
        WebClientInfo info = WicketUtils.getClientInfo();
        return info == null ? null : info.getUserAgent();
    }

    public static boolean isCookiesDisabled() {
        WebClientInfo info = WicketUtils.getClientInfo();
        return info == null || info.getProperties() == null ? false : !info.getProperties().isCookiesEnabled();
    }

    public static String getClientInfoString() {
        WebClientInfo info = WicketUtils.getClientInfo();
        return info == null ? null : info.getUserAgent() + " (" + info.getProperties().getRemoteAddress() + ")";
    }

    public static String getRequestContextPath() {
        HttpServletRequest r = WicketUtils.getHttpServletRequest();
        if (r == null) {
            return null;
        }
        try {
            URL url = new URL(r.getRequestURL().toString());
            StringBuilder buf = new StringBuilder(100);
            buf.append(url.getProtocol()).append("://").append(url.getHost());
            if (url.getPort() != -1) {
                buf.append(":").append(url.getPort());
            }
            return buf.append(r.getContextPath()).toString();
        }
        catch (MalformedURLException e) {
            throw new WicketRuntimeException("client sent an illegal url?", (Throwable)e);
        }
    }

    public static String getHost() {
        HttpServletRequest r = WicketUtils.getHttpServletRequest();
        if (r == null) {
            return null;
        }
        try {
            return new URL(r.getRequestURL().toString()).getHost();
        }
        catch (MalformedURLException e) {
            throw new WicketRuntimeException("client sent an illegal url?", (Throwable)e);
        }
    }

    public static String toAbsolutePath(Class<? extends Page> pageClass) {
        return WicketUtils.toAbsolutePath(pageClass, null);
    }

    public static String toAbsolutePath(Class<? extends Page> pageClass, PageParameters parameters) {
        return RequestUtils.toAbsolutePath((String)((Object)RequestCycle.get().urlFor(pageClass, parameters)).toString());
    }

    public static void performRedirect(String targetURL, int statusCode) {
        BufferedWebResponse response = (BufferedWebResponse)RequestCycle.get().getResponse();
        response.getHttpServletResponse().setHeader("Location", targetURL);
        throw new AbortWithHttpStatusException(301, true);
    }

    public static void performRedirect(Class<? extends Page> pageClass, PageParameters parameters, int statusCode) {
        WicketUtils.performRedirect(WicketUtils.toAbsolutePath(pageClass, parameters), statusCode);
    }

    public static URL toUrl(Class<? extends Page> pageClass) {
        return WicketUtils.toUrl(pageClass, null);
    }

    public static URL toUrl(Class<? extends Page> pageClass, PageParameters params) {
        String url = WicketUtils.toAbsolutePath(pageClass, params);
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new WicketRuntimeException("failed to create URL from " + url, (Throwable)e);
        }
    }

    public static class UrlRequest
    extends Request {
        private final ValueMap params = new ValueMap();
        private final Request realRequest;
        private final URL url;

        public UrlRequest(Request realRequest, URL url) {
            this.realRequest = realRequest;
            this.url = url;
            String query = url.getQuery();
            if (query != null) {
                RequestUtils.decodeParameters((String)query, (ValueMap)this.params);
            }
        }

        public Locale getLocale() {
            return this.realRequest.getLocale();
        }

        public String getParameter(String key) {
            return (String)this.params.get((Object)key);
        }

        public Map getParameterMap() {
            return this.params;
        }

        public String[] getParameters(String key) {
            String param = (String)this.params.get((Object)key);
            if (param != null) {
                return new String[]{param};
            }
            return new String[0];
        }

        public String getPath() {
            String path = this.url.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            return path;
        }

        public String getRelativePathPrefixToContextRoot() {
            throw new NotImplementedException();
        }

        public String getRelativePathPrefixToWicketHandler() {
            throw new NotImplementedException();
        }

        public String getURL() {
            return this.url.toString();
        }

        public String getQueryString() {
            return this.realRequest.getQueryString();
        }
    }
}

