/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class DnsUtils {
    private DnsUtils() {
    }

    public static String getLocalHostName() {
        try {
            String name = InetAddress.getLocalHost().getCanonicalHostName();
            if (name == null || name.length() == 0) {
                return "localhost";
            }
            if (name.equals(InetAddress.getLocalHost().getHostAddress())) {
                return "localhost";
            }
            return name;
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public static String[] lookupMailHosts(String domainName) throws NamingException {
        InitialDirContext iDirC = new InitialDirContext();
        Attributes attributes = iDirC.getAttributes("dns:/" + domainName, new String[]{"MX"});
        Attribute attributeMX = attributes.get("MX");
        if (attributeMX == null) {
            return new String[]{domainName};
        }
        String[][] pvhn = new String[attributeMX.size()][2];
        for (int i = 0; i < attributeMX.size(); ++i) {
            pvhn[i] = ("" + attributeMX.get(i)).split("\\s+");
        }
        Arrays.sort(pvhn, new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                return Integer.parseInt(o1[0]) - Integer.parseInt(o2[0]);
            }
        });
        String[] sortedHostNames = new String[pvhn.length];
        for (int i = 0; i < pvhn.length; ++i) {
            sortedHostNames[i] = pvhn[i][1].endsWith(".") ? pvhn[i][1].substring(0, pvhn[i][1].length() - 1) : pvhn[i][1];
        }
        return sortedHostNames;
    }
}

