/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.data;

import at.molindo.utils.data.HexUtils;
import at.molindo.utils.io.CharsetUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class Hash {
    private final byte[] _bytes;
    private IAlgorithm _algorithm;

    public static Hash md5(String content) {
        return Hash.hash(Algorithm.MD5, content);
    }

    public static Hash md5(byte[] content) {
        return Hash.hash(Algorithm.MD5, content);
    }

    public static Hash sha256(String content) {
        return Hash.hash(Algorithm.SHA_256, content);
    }

    public static Hash sha256(byte[] content) {
        return Hash.hash(Algorithm.SHA_256, content);
    }

    public static Hash sha512(String content) {
        return Hash.hash(Algorithm.SHA_512, content);
    }

    public static Hash sha512(byte[] content) {
        return Hash.hash(Algorithm.SHA_512, content);
    }

    public static Hash hash(Algorithm algorithm, String content) {
        return algorithm.builder().add(content).hash();
    }

    public static Hash hash(Algorithm algorithm, byte[] content) {
        return algorithm.builder().add(content).hash();
    }

    public Hash(String hex, IAlgorithm algorithm) {
        this(HexUtils.bytes(hex), algorithm);
    }

    public Hash(byte[] bytes, IAlgorithm algorithm) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        if (algorithm == null) {
            throw new NullPointerException("algorithm");
        }
        this._bytes = bytes;
        this._algorithm = algorithm;
    }

    public String toHex() {
        return HexUtils.string(this._bytes);
    }

    public IAlgorithm getAlgorithm() {
        return this._algorithm;
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public String toString() {
        return this.toHex();
    }

    public boolean validate(String content) {
        return this.equals(this.getAlgorithm().builder().add(content).hash());
    }

    public boolean validate(String content, Charset charset) {
        return this.equals(this.getAlgorithm().builder().add(content, charset).hash());
    }

    public boolean validate(byte[] content) {
        return this.equals(this.getAlgorithm().builder().add(content).hash());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._algorithm == null ? 0 : this._algorithm.hashCode());
        result = 31 * result + Arrays.hashCode(this._bytes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hash other = (Hash)obj;
        if (this._algorithm == null ? other._algorithm != null : !this._algorithm.equals(other._algorithm)) {
            return false;
        }
        return Arrays.equals(this._bytes, other._bytes);
    }

    public static enum Algorithm implements IAlgorithm
    {
        MD2,
        MD5,
        SHA,
        SHA_256,
        SHA_384,
        SHA_512;

        private final String _name = this.name().replace('_', '-');

        public String getName() {
            return this._name;
        }

        @Override
        public IHashBuilder builder() {
            return new IHashBuilder(){
                private final MessageDigest _md;
                {
                    this._md = Algorithm.this.newMessageDigest();
                }

                @Override
                public IHashBuilder add(byte[] bytes) {
                    this._md.update(bytes);
                    return this;
                }

                @Override
                public IHashBuilder add(ByteBuffer bytes) {
                    this._md.update(bytes);
                    return this;
                }

                @Override
                public IHashBuilder add(String string) {
                    return this.add(string, CharsetUtils.UTF_8);
                }

                @Override
                public IHashBuilder add(String string, Charset charset) {
                    this._md.update(string.getBytes(charset));
                    return this;
                }

                @Override
                public Hash hash() {
                    return new Hash(this._md.digest(), (IAlgorithm)Algorithm.this);
                }

                @Override
                public IHashBuilder reset() {
                    this._md.reset();
                    return this;
                }
            };
        }

        private MessageDigest newMessageDigest() {
            try {
                return MessageDigest.getInstance(this.getName());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("no such algorithm: " + this.getName(), e);
            }
        }
    }

    public static interface IAlgorithm {
        public IHashBuilder builder();
    }

    public static interface IHashBuilder {
        public IHashBuilder add(String var1);

        public IHashBuilder add(String var1, Charset var2);

        public IHashBuilder add(byte[] var1);

        public IHashBuilder add(ByteBuffer var1);

        public Hash hash();

        public IHashBuilder reset();
    }
}

