/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class KeyLock<K, V> {
    private final ConcurrentHashMap<K, Task> _map = new ConcurrentHashMap();

    public static <K, V> KeyLock<K, V> newKeyLock() {
        return new KeyLock<K, V>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V withLock(K key, Callable<V> callable) throws Exception {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (callable == null) {
            throw new NullPointerException("callable");
        }
        try {
            Task t = new Task(callable);
            Task prev = this._map.putIfAbsent(key, t);
            if (prev != null) {
                t = prev;
                this.onExisting(key);
            }
            Object v = t.perform();
            return v;
        }
        finally {
            this._map.remove(key);
        }
    }

    protected void onExisting(K key) throws Exception {
    }

    protected V replace(V result, Exception ex) throws Exception {
        return null;
    }

    public int activeCount() {
        return this._map.size();
    }

    public List<K> activeKeys() {
        return new ArrayList(this._map.keySet());
    }

    private final class Task {
        private final Callable<V> _callable;
        private Exception _ex;
        private boolean _done = false;
        private V _result;

        public Task(Callable<V> callable) {
            this._callable = callable;
        }

        public synchronized V perform() throws Exception {
            if (!this._done) {
                try {
                    Object v = this._result = this._callable.call();
                    return v;
                }
                catch (Exception e) {
                    this._ex = e;
                    throw e;
                }
                finally {
                    this._done = true;
                }
            }
            return KeyLock.this.replace(this._result, this._ex);
        }
    }
}

