/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.util;

import at.molindo.notify.INotifyService;
import at.molindo.notify.model.IParams;
import at.molindo.notify.render.IRenderService;
import at.molindo.notify.render.velocity.SLF4JLogChute;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.parser.ParseException;

public class VelocityUtils {
    private VelocityUtils() {
    }

    public static RuntimeServices newRuntime() {
        try {
            RuntimeInstance runtime = new RuntimeInstance();
            runtime.setProperty("runtime.log.logsystem", (Object)new SLF4JLogChute());
            runtime.setProperty("runtime.references.strict", (Object)true);
            runtime.init();
            return runtime;
        }
        catch (Exception e) {
            throw new INotifyService.NotifyRuntimeException("failed to init velocity runtime", e);
        }
    }

    public static String merge(RuntimeServices runtime, String content, String templateName, IParams params) throws IRenderService.RenderException {
        return VelocityUtils.merge(VelocityUtils.newTemplate(runtime, content, templateName), params);
    }

    public static String merge(Template template, IParams params) throws IRenderService.RenderException {
        return VelocityUtils.merge(template, params, null);
    }

    public static String merge(Template template, IParams params, Context nestedContext) throws IRenderService.RenderException {
        try {
            StringWriter writer = new StringWriter();
            template.merge((Context)new VelocityContext(params.newMap(), nestedContext), (Writer)writer);
            return writer.toString();
        }
        catch (ResourceNotFoundException e) {
            throw new IRenderService.RenderException("failed to render template " + template, e);
        }
        catch (ParseErrorException e) {
            throw new IRenderService.RenderException("failed to render template " + template, e);
        }
        catch (MethodInvocationException e) {
            throw new IRenderService.RenderException("failed to render template " + template, e);
        }
    }

    public static Template newTemplate(RuntimeServices runtime, String content, String templateName) throws IRenderService.RenderException {
        try {
            Template vt = new Template();
            vt.setRuntimeServices(runtime);
            vt.setData((Object)runtime.parse((Reader)new StringReader(content), templateName));
            vt.initDocument();
            return vt;
        }
        catch (ParseException e) {
            throw new IRenderService.RenderException("failed to parse template", e);
        }
    }
}

