/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.model;

import at.molindo.notify.model.Param;
import at.molindo.notify.model.ParamValue;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;

public interface IParams
extends Cloneable,
Iterable<ParamValue> {
    public <T> IParams set(Param<T> var1, T var2);

    public <T> T get(Param<T> var1);

    public boolean isSet(Param<?> var1);

    public boolean containsAll(Param<?> ... var1);

    public IParams setAll(IParams var1);

    public Map<String, Object> newMap();

    @Override
    public Iterator<ParamValue> iterator();

    public static class Util {
        protected static boolean containsAll(IParams target, Param<?> ... params) {
            for (Param<?> param : params) {
                if (target.isSet(param)) continue;
                return false;
            }
            return true;
        }

        protected static void setAll(@Nonnull IParams target, IParams source) {
            if (target == null) {
                throw new NullPointerException("target");
            }
            if (source != null) {
                for (ParamValue v : source) {
                    v.set(target);
                }
            }
        }

        protected static Map<String, Object> newMap(IParams target) {
            HashMap map = Maps.newHashMap();
            for (ParamValue v : target) {
                map.put(v.getName(), v.getValue());
            }
            return map;
        }
    }
}

