/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.model;

import at.molindo.notify.INotifyService;
import at.molindo.notify.channel.feed.AbstractFeedChannel;
import at.molindo.notify.channel.feed.AbstractPullChannel;
import at.molindo.notify.model.ChannelPreferences;
import at.molindo.notify.model.IRequestConfigurable;

public class ConfigurableChannelPreferences
extends ChannelPreferences
implements IRequestConfigurable {
    @Override
    public void setParam(String name, String value) throws INotifyService.NotifyException {
        if (value == null) {
            return;
        }
        if (AbstractPullChannel.AMOUNT.getName().equals(name)) {
            try {
                int amount = AbstractPullChannel.AMOUNT.toObject(value);
                if (amount <= 0 || amount > 100) {
                    throw new INotifyService.NotifyException("illegal amount: " + amount);
                }
                this.getParams().set(AbstractFeedChannel.AMOUNT, amount);
            }
            catch (NumberFormatException e) {
                throw new INotifyService.NotifyException("can't convert value to Number: " + value, e);
            }
        } else if (AbstractPullChannel.SECRET.getName().equals(name)) {
            this.getParams().set(AbstractFeedChannel.SECRET, value);
        }
    }
}

