/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.dispatch;

import at.molindo.notify.INotifyService;
import at.molindo.notify.dispatch.AbstractPushDispatcher;
import at.molindo.notify.model.Notification;
import at.molindo.notify.util.AbstractSmartLifecycle;
import at.molindo.utils.concurrent.FactoryThread;
import at.molindo.utils.concurrent.KeyLock;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;

public class PollingPushDispatcher
extends AbstractPushDispatcher
implements INotifyService.INotificationListner,
DisposableBean,
SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(PollingPushDispatcher.class);
    private static final int DEFAULT_POOL_SIZE = 1;
    private int _poolSize = 1;
    private INotifyService _notifyService;
    private final Object _wait = new Object();
    private final KeyLock<Long, Void> _notificationLock = KeyLock.newKeyLock((boolean)false);
    private FactoryThread.FactoryThreadGroup _threadGroup;
    private final Lifecycle _lifecycle = new Lifecycle();

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this._threadGroup = new FactoryThread.FactoryThreadGroup(PollingPushDispatcher.class.getSimpleName(), this._poolSize, new FactoryThread.IRunnableFactory(){

            public Runnable newRunnable() {
                return new Polling();
            }
        });
        this._notifyService.addNotificationListener(this);
    }

    public void destroy() {
        this.stop();
        this._notifyService.removeNotificationListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notification(Notification notification) {
        Object object = this._wait;
        synchronized (object) {
            this._wait.notify();
        }
    }

    public void setNotifyService(INotifyService notifyService) {
        this._notifyService = notifyService;
    }

    public int getPoolSize() {
        return this._poolSize;
    }

    public void setPoolSize(int poolSize) {
        this._poolSize = poolSize;
    }

    public void start() {
        this._lifecycle.start();
    }

    public void stop() {
        this._lifecycle.stop();
    }

    public boolean isRunning() {
        return this._lifecycle.isRunning();
    }

    public int getPhase() {
        return this._lifecycle.getPhase();
    }

    public boolean isAutoStartup() {
        return this._lifecycle.isAutoStartup();
    }

    public void stop(Runnable callback) {
        this._lifecycle.stop(callback);
    }

    private class Lifecycle
    extends AbstractSmartLifecycle {
        private volatile boolean _running = false;

        private Lifecycle() {
        }

        @Override
        public boolean isRunning() {
            return this._running;
        }

        @Override
        protected void doStart() {
            PollingPushDispatcher.this._threadGroup.start();
            this._running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doStop() {
            PollingPushDispatcher.this._threadGroup.setInactive();
            this._running = false;
            Object object = PollingPushDispatcher.this._wait;
            synchronized (object) {
                PollingPushDispatcher.this._wait.notifyAll();
            }
            try {
                log.info("waiting for termination of running notification tasks");
                PollingPushDispatcher.this._threadGroup.join();
                log.info("all running notification tasks terminated");
            }
            catch (InterruptedException e1) {
                log.warn("interrupted while waiting for termination of notificaiton tasks");
            }
        }
    }

    class Polling
    implements Runnable {
        Polling() {
        }

        @Override
        public void run() {
            Notification notification = PollingPushDispatcher.this.getNotificationDAO().getNext();
            if (notification != null) {
                this.doPush(notification);
            } else {
                this.delay();
            }
        }

        @CheckForNull
        private void doPush(final @Nonnull Notification notification) {
            try {
                PollingPushDispatcher.this._notificationLock.withLock((Object)notification.getId(), (Callable)new Callable<Void>(){

                    @Override
                    public Void call() {
                        PollingPushDispatcher.this.dispatch(notification);
                        return null;
                    }
                });
            }
            catch (KeyLock.KeyLockedException e) {
                log.info("notification id currently locked: " + e.getKey());
            }
            catch (Exception e) {
                throw new INotifyService.NotifyRuntimeException("unexepcted exception from doPush()", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void delay() {
            Object object = PollingPushDispatcher.this._wait;
            synchronized (object) {
                try {
                    PollingPushDispatcher.this._wait.wait(TimeUnit.SECONDS.toMillis(20L));
                }
                catch (InterruptedException e) {
                    log.debug("polling thread interrupted", (Throwable)e);
                }
            }
        }
    }
}

