/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.dispatch;

import at.molindo.notify.INotifyService;
import at.molindo.notify.dispatch.IDispatchService;
import at.molindo.notify.model.Dispatch;
import at.molindo.notify.model.IChannelPreferences;
import at.molindo.notify.model.IPreferences;
import at.molindo.notify.model.Notification;
import at.molindo.notify.model.Params;
import at.molindo.notify.render.IRenderService;
import at.molindo.notify.servlet.INotifyUrlFactory;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchService
implements IDispatchService {
    private static final Logger log = LoggerFactory.getLogger(DispatchService.class);
    private IRenderService _renderService;
    private final List<INotifyService.IParamsFactory> _paramsFactories = new CopyOnWriteArrayList<INotifyService.IParamsFactory>();
    private INotifyUrlFactory _notifyUrlFactory;

    @Override
    public Dispatch create(Notification notification, IPreferences prefs, IChannelPreferences cPrefs) throws IRenderService.RenderException {
        Params params = new Params();
        params.setAll(prefs.getParams());
        params.setAll(cPrefs.getParams());
        params.setAll(notification.getParams());
        params.set(INotifyService.NOTIFICATION, notification);
        params.set(INotifyService.PREFERENCES, prefs);
        params.set(INotifyService.CHANNEL_PREFERENCES, cPrefs);
        if (notification.getConfirmation() != null) {
            if (this._notifyUrlFactory != null) {
                params.set(INotifyService.CONFIRMATION_URL, this._notifyUrlFactory.toConfirmPath(notification.getConfirmation()));
            } else {
                log.warn("can't set confirmation URL without NotifyFilter");
            }
        }
        for (INotifyService.IParamsFactory factory : this._paramsFactories) {
            try {
                factory.params(params);
            }
            catch (INotifyService.NotifyException e) {
                throw new IRenderService.RenderException("params unavailable", e);
            }
        }
        String key = notification.getKey();
        IRenderService.Version version = cPrefs.getVersion();
        return new Dispatch(this._renderService.render(key, version, params), params);
    }

    public void setRenderService(IRenderService renderService) {
        this._renderService = renderService;
    }

    @Override
    public void addParamsFactory(INotifyService.IParamsFactory factory) {
        this._paramsFactories.add(factory);
    }

    @Override
    public void removeParamsFactory(INotifyService.IParamsFactory factory) {
        this._paramsFactories.removeAll(Arrays.asList(factory));
    }

    public void setParamsFactories(List<INotifyService.IParamsFactory> factories) {
        this._paramsFactories.clear();
        this._paramsFactories.addAll(factories);
    }

    public void setNotifyUrlFactory(INotifyUrlFactory notifyUrlFactory) {
        this._notifyUrlFactory = notifyUrlFactory;
    }
}

