/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.confirm;

import at.molindo.notify.INotifyService;
import at.molindo.notify.confirm.IConfirmationService;
import at.molindo.notify.dao.INotificationDAO;
import at.molindo.notify.model.Notification;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class ConfirmationService
implements IConfirmationService {
    private static final long DEFAULT_CONFIRMATION_MAX_AGE_MS = TimeUnit.DAYS.toMillis(14L);
    private INotificationDAO _notificationDAO;
    private final List<INotifyService.IConfirmationListener> _confirmationListeners = new CopyOnWriteArrayList<INotifyService.IConfirmationListener>();
    private long _confirmationMaxAgeMs = DEFAULT_CONFIRMATION_MAX_AGE_MS;

    public void setConfirmationListeners(Collection<? extends INotifyService.IConfirmationListener> listeners) {
        if (this._confirmationListeners.size() > 0) {
            throw new IllegalStateException("already listeneres registered: " + this._confirmationListeners);
        }
        this._confirmationListeners.addAll(listeners);
    }

    @Override
    public void addConfirmationListener(INotifyService.IConfirmationListener listener) {
        this._confirmationListeners.add(listener);
    }

    @Override
    public void removeConfirmationListener(INotifyService.IConfirmationListener listener) {
        this._confirmationListeners.removeAll(Arrays.asList(listener));
    }

    @Override
    public String confirm(String key) throws IConfirmationService.ConfirmationException {
        Notification notification = this._notificationDAO.getByConfirmationKey(key);
        if (notification == null) {
            return null;
        }
        if (System.currentTimeMillis() - notification.getDate().getTime() > this._confirmationMaxAgeMs) {
            return null;
        }
        for (INotifyService.IConfirmationListener l : this._confirmationListeners) {
            String redirect = l.confirm(notification);
            if (redirect == null) continue;
            if (!redirect.startsWith("/")) {
                throw new IllegalArgumentException("redirect path must be absolute, was " + redirect);
            }
            return redirect;
        }
        throw new IConfirmationService.ConfirmationException("unhandled notification " + notification);
    }

    @Override
    public Notification getNotificationByKey(String key) {
        return key == null ? null : this._notificationDAO.getByConfirmationKey(key);
    }

    public void setNotificationDAO(INotificationDAO notificationDAO) {
        this._notificationDAO = notificationDAO;
    }

    protected long getConfirmationMaxAgeMs() {
        return this._confirmationMaxAgeMs;
    }

    protected void setConfirmationMaxAgeMs(long confirmationMaxAgeMs) {
        this._confirmationMaxAgeMs = confirmationMaxAgeMs;
    }
}

