/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.channel.mail;

import at.molindo.notify.channel.mail.IMailClient;
import at.molindo.notify.model.Dispatch;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;

public class RoundRobinMailClient
implements IMailClient {
    private final CopyOnWriteArrayList<IMailClient> _clients = new CopyOnWriteArrayList();
    private final Object _mutex = new Object();
    private Iterator<IMailClient> _iter = this.newIterator();

    @Override
    public void send(Dispatch dispatch) throws IMailClient.MailException {
        this.getNext().send(dispatch);
    }

    private IMailClient getNext() throws IMailClient.MailException {
        Object object = this._mutex;
        synchronized (object) {
            try {
                return this._iter.next();
            }
            catch (NoSuchElementException e) {
                throw new IMailClient.MailException("no client available", e, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClients(Collection<IMailClient> clients) {
        Object object = this._mutex;
        synchronized (object) {
            this._clients.clear();
            this._clients.addAll(clients);
            this._iter = this.newIterator();
        }
    }

    private Iterator<IMailClient> newIterator() {
        return Iterators.cycle(this._clients);
    }
}

