/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.channel.mail;

import at.molindo.notify.channel.mail.IMailClient;
import at.molindo.utils.data.StringUtils;
import at.molindo.utils.io.CharsetUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class MailUtils {
    private MailUtils() {
    }

    public static String domainFromAddress(String address) throws IMailClient.MailException {
        String[] parts = new String[2];
        try {
            if (StringUtils.split((String)address, (String)"@", (String[])parts) == 2) {
                return parts[1];
            }
            throw new IMailClient.MailException("illegal address: " + address, false);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IMailClient.MailException("illegal address: " + address, e, false);
        }
    }

    public static String toString(MimeMessage mm) throws MessagingException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            mm.writeTo((OutputStream)os);
            String message = new String(os.toByteArray(), CharsetUtils.US_ASCII);
            return message;
        }
        catch (IOException e) {
            throw new RuntimeException("can't write to ByteArrayOutputStream", e);
        }
    }
}

