/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.channel.mail;

import at.molindo.notify.channel.IPushChannel;
import at.molindo.notify.channel.mail.IMailClient;
import at.molindo.notify.channel.mail.IMailFilter;
import at.molindo.notify.model.Dispatch;
import at.molindo.notify.model.IParams;
import at.molindo.notify.model.IPushChannelPreferences;
import at.molindo.notify.model.Notification;
import at.molindo.notify.model.Param;
import at.molindo.notify.model.Params;
import at.molindo.notify.model.PushChannelPreferences;
import at.molindo.utils.net.DnsUtils;
import com.google.common.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class MailChannel
implements IPushChannel,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MailChannel.class);
    public static final Param<String> RECIPIENT = Param.pString("recipient");
    public static final Param<String> RECIPIENT_NAME = Param.pString("name");
    public static final String CHANNEL_ID = "mail";
    private IMailFilter _mailFilter;
    private IPushChannelPreferences _defaultPreferences;
    private IMailClient _mailClient;
    private boolean _disabled = false;

    public static void setRecipient(IPushChannelPreferences cPrefs, String recipient) {
        MailChannel.setRecipient(cPrefs.getParams(), recipient);
    }

    public static void setRecipientName(IPushChannelPreferences cPrefs, String recipientName) {
        MailChannel.setRecipientName(cPrefs.getParams(), recipientName);
    }

    public static void setRecipient(IParams params, String recipient) {
        params.set(RECIPIENT, recipient);
    }

    public static void setRecipientName(IParams params, String recipientName) {
        params.set(RECIPIENT_NAME, recipientName);
    }

    public static String getRecipient(IPushChannelPreferences cPrefs) {
        return MailChannel.getRecipient(cPrefs.getParams());
    }

    public static String getRecipientName(IPushChannelPreferences cPrefs) {
        return MailChannel.getRecipientName(cPrefs.getParams());
    }

    public static String getRecipient(IParams params) {
        return params.get(RECIPIENT);
    }

    public static String getRecipientName(IParams params) {
        return params.get(RECIPIENT_NAME);
    }

    public void afterPropertiesSet() throws Exception {
        String localHostName = DnsUtils.getLocalHostName();
        if (localHostName == null || localHostName.indexOf(46) < 0) {
            log.warn("hostname of localhost seems not to be correct: " + localHostName);
        } else {
            log.info("hostname of localhost seems to be correct: " + localHostName);
        }
        if (this._mailClient == null) {
            throw new Exception("mailClient not configured");
        }
    }

    @Override
    public String getId() {
        return CHANNEL_ID;
    }

    @Override
    public ImmutableSet<Notification.Type> getNotificationTypes() {
        return Notification.Type.TYPES_PRIVATE;
    }

    @Override
    public IPushChannelPreferences newDefaultPreferences() {
        return this._defaultPreferences != null ? this._defaultPreferences.clone() : new PushChannelPreferences();
    }

    @Override
    public void push(Dispatch dispatch) throws IPushChannel.PushException {
        if (this.isDisabled()) {
            throw new IPushChannel.PushException("channel is disabled", true);
        }
        try {
            this._mailClient.send(dispatch);
            if (log.isTraceEnabled()) {
                log.trace("successfully pushed mail:\n" + dispatch.getMessage());
            }
        }
        catch (IPushChannel.PushException e) {
            if (log.isTraceEnabled()) {
                log.trace("failed to push mail:\n" + dispatch.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public boolean isConfigured(Params params) {
        if (this._mailFilter != null && !this._mailFilter.isAllowed(params)) {
            return false;
        }
        return params.containsAll(RECIPIENT);
    }

    public IPushChannelPreferences getDefaultPreferences() {
        return this._defaultPreferences;
    }

    public void setDefaultPreferences(IPushChannelPreferences defaultPreferences) {
        this._defaultPreferences = defaultPreferences;
    }

    public IMailClient getMailClient() {
        return this._mailClient;
    }

    public void setMailClient(IMailClient mailClient) {
        this._mailClient = mailClient;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }

    public void setMailFilter(IMailFilter mailFilter) {
        this._mailFilter = mailFilter;
    }
}

