/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.channel.mail;

import at.molindo.notify.INotifyService;
import at.molindo.notify.channel.mail.IMailClient;
import at.molindo.notify.channel.mail.MailChannel;
import at.molindo.notify.model.Dispatch;
import at.molindo.notify.model.Message;
import at.molindo.notify.render.IRenderService;
import at.molindo.utils.io.CharsetUtils;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractMailClient
implements IMailClient,
InitializingBean {
    private InternetAddress _from;
    private InternetAddress _replyTo;
    private Format _format = Format.MULTI;

    public final void afterPropertiesSet() throws Exception {
        this.init();
    }

    public AbstractMailClient init() throws IMailClient.MailException {
        if (this._from == null) {
            throw new IMailClient.MailException("from address is not configured", true);
        }
        return this;
    }

    @Override
    public synchronized void send(Dispatch dispatch) throws IMailClient.MailException {
        Message message = dispatch.getMessage();
        String recipient = dispatch.getParams().get(MailChannel.RECIPIENT);
        String recipientName = dispatch.getParams().get(MailChannel.RECIPIENT_NAME);
        String subject = message.getSubject();
        try {
            MimeMessage mm = new MimeMessage(this.getSmtpSession(recipient)){

                protected void updateMessageID() throws MessagingException {
                    String domain = AbstractMailClient.this._from.getAddress();
                    int idx = AbstractMailClient.this._from.getAddress().indexOf(64);
                    if (idx >= 0) {
                        domain = domain.substring(idx + 1);
                    }
                    this.setHeader("Message-ID", "<" + UUID.randomUUID() + "@" + domain + ">");
                }
            };
            mm.setFrom((Address)this._from);
            mm.setSender((Address)this._from);
            InternetAddress replyTo = this.getReplyTo();
            if (replyTo != null) {
                mm.setReplyTo(new Address[]{replyTo});
            }
            mm.setHeader("X-Mailer", "molindo-notify");
            mm.setSentDate(new Date());
            mm.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient, recipientName, CharsetUtils.UTF_8.displayName()));
            mm.setSubject(subject, CharsetUtils.UTF_8.displayName());
            if (this._format == Format.HTML) {
                if (message.getType() == IRenderService.Type.TEXT) {
                    throw new IMailClient.MailException("can't send HTML mail from TEXT message", false);
                }
                mm.setText(message.getHtml(), CharsetUtils.UTF_8.displayName(), "html");
            } else if (this._format == Format.TEXT || this._format == Format.MULTI && message.getType() == IRenderService.Type.TEXT) {
                mm.setText(message.getText(), CharsetUtils.UTF_8.displayName());
            } else if (this._format == Format.MULTI) {
                MimeBodyPart html = new MimeBodyPart();
                html.setText(message.getHtml(), CharsetUtils.UTF_8.displayName(), "html");
                MimeBodyPart text = new MimeBodyPart();
                text.setText(message.getText(), CharsetUtils.UTF_8.displayName());
                MimeMultipart mmp = new MimeMultipart();
                mmp.setSubType("alternative");
                mmp.addBodyPart((BodyPart)text);
                mmp.addBodyPart((BodyPart)html);
                mm.setContent((Multipart)mmp);
            } else {
                throw new INotifyService.NotifyRuntimeException("unexpected format (" + (Object)((Object)this._format) + ") or type (" + (Object)((Object)message.getType()) + ")");
            }
            this.send(mm);
        }
        catch (MessagingException e) {
            throw new IMailClient.MailException("could not send mail from " + this._from + " to " + recipient + " (" + this.toErrorMessage(e) + ")", e, this.isTemporary(e));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("utf8 unknown?", e);
        }
    }

    protected void send(MimeMessage mm) throws MessagingException {
        Transport.send((javax.mail.Message)mm);
    }

    protected String toErrorMessage(MessagingException e) {
        return e == null ? null : e.getMessage();
    }

    protected boolean isTemporary(MessagingException e) {
        return true;
    }

    protected abstract Session getSmtpSession(String var1) throws IMailClient.MailException;

    public InternetAddress getFrom() {
        return this._from;
    }

    public AbstractMailClient setFrom(InternetAddress from) {
        this._from = from;
        return this;
    }

    public AbstractMailClient setFrom(String address) throws AddressException {
        return this.setFrom(new InternetAddress(address));
    }

    public AbstractMailClient setFrom(String address, String personal) throws AddressException {
        try {
            return this.setFrom(new InternetAddress(address, personal, CharsetUtils.UTF_8.displayName()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("utf8 not supported?", e);
        }
    }

    public InternetAddress getReplyTo() {
        return this._replyTo;
    }

    public AbstractMailClient setReplyTo(InternetAddress replyTo) {
        this._replyTo = replyTo;
        return this;
    }

    public AbstractMailClient setReplyTo(String address) throws AddressException {
        return this.setReplyTo(new InternetAddress(address));
    }

    public AbstractMailClient setReplyTo(String address, String personal) throws AddressException {
        try {
            return this.setReplyTo(new InternetAddress(address, personal, CharsetUtils.UTF_8.displayName()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("utf8 not supported?", e);
        }
    }

    public Format getFormat() {
        return this._format;
    }

    public AbstractMailClient setFormat(Format format) {
        if (format == null) {
            throw new NullPointerException("format");
        }
        this._format = format;
        return this;
    }

    public static enum Format {
        MULTI,
        HTML,
        TEXT;

    }

    public static enum Security {
        NONE(25),
        SSL(465),
        TLS(587);

        private final int _defaultPort;

        private Security(int defaultPort) {
            this._defaultPort = defaultPort;
        }

        public int getDefaultPort() {
            return this._defaultPort;
        }
    }
}

