/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.channel.feed;

import at.molindo.notify.channel.IPullChannel;
import at.molindo.notify.dao.INotificationDAO;
import at.molindo.notify.dao.IPreferencesDAO;
import at.molindo.notify.dispatch.IDispatchService;
import at.molindo.notify.model.ConfigurableChannelPreferences;
import at.molindo.notify.model.IChannelPreferences;
import at.molindo.notify.model.IPreferences;
import at.molindo.notify.model.Message;
import at.molindo.notify.model.Notification;
import at.molindo.notify.model.Param;
import at.molindo.notify.model.Params;
import at.molindo.notify.render.IRenderService;
import at.molindo.utils.data.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public abstract class AbstractPullChannel
implements IPullChannel {
    private IDispatchService _dispatchService;
    private INotificationDAO _notificationDAO;
    private IPreferencesDAO _preferencesDAO;
    public static final Param<String> SECRET = Param.pString("secret");
    public static final Param<Integer> AMOUNT = Param.pInteger("amount");
    public static final int MAX_AMOUNT = 100;
    public static final int DEFAULT_AMOUNT = 25;
    private Integer _defaultAmount = 25;

    @Override
    public boolean isAuthorized(String userId, IChannelPreferences cPrefs) {
        IPreferences p = this._preferencesDAO.getPreferences(userId);
        if (p == null) {
            return false;
        }
        String prefSecret = p.getParams().get(SECRET);
        String reqSecret = cPrefs.getParams().get(SECRET);
        return prefSecret != null && StringUtils.equals((String)prefSecret, (String)reqSecret);
    }

    @Override
    public boolean isConfigured(Params params) {
        return true;
    }

    @Override
    public final String pull(String userId, IChannelPreferences cPrefs) throws IPullChannel.PullException {
        List<Notification> notifications;
        IPreferences prefs = this._preferencesDAO.getPreferences(userId);
        Integer amount = cPrefs.getParams().get(AMOUNT);
        if (amount == null) {
            amount = this._defaultAmount;
        }
        if ((notifications = this._notificationDAO.getRecent(userId, (Set<Notification.Type>)this.getNotificationTypes(), 0, amount)).size() == 0) {
            throw new IPullChannel.PullException("no notifications found");
        }
        Date lastModified = notifications.get(0).getDate();
        ArrayList messages = Lists.newArrayListWithCapacity((int)notifications.size());
        for (Notification notification : notifications) {
            try {
                messages.add(this.render(notification, prefs, cPrefs));
            }
            catch (IRenderService.RenderException e) {
                throw new IPullChannel.PullException("failed to render notification: " + notification, e);
            }
        }
        return this.pull(messages, lastModified, cPrefs, prefs);
    }

    @Override
    public IChannelPreferences newDefaultPreferences() {
        ConfigurableChannelPreferences prefs = new ConfigurableChannelPreferences();
        prefs.setVersion(IRenderService.Version.LONG);
        return prefs;
    }

    protected Message render(Notification notification, IPreferences prefs, IChannelPreferences cPrefs) throws IRenderService.RenderException {
        return this._dispatchService.create(notification, prefs, cPrefs).getMessage();
    }

    public Integer getDefaultAmount() {
        return this._defaultAmount;
    }

    public void setDefaultAmount(Integer defaultAmount) {
        this._defaultAmount = defaultAmount;
    }

    public void setNotificationDAO(INotificationDAO notificationDAO) {
        this._notificationDAO = notificationDAO;
    }

    public void setPreferencesDAO(IPreferencesDAO preferencesDAO) {
        this._preferencesDAO = preferencesDAO;
    }

    public void setDispatchService(IDispatchService dispatchService) {
        this._dispatchService = dispatchService;
    }

    @Deprecated
    public void setNotificationRenderService(IDispatchService dispatchService) {
        this.setDispatchService(dispatchService);
    }

    protected abstract String pull(List<Message> var1, Date var2, IChannelPreferences var3, IPreferences var4) throws IPullChannel.PullException;
}

