/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify;

import at.molindo.notify.channel.IPushChannel;
import at.molindo.notify.model.IParams;
import at.molindo.notify.model.IPreferences;
import at.molindo.notify.model.Notification;
import at.molindo.notify.model.Param;
import at.molindo.notify.model.Params;
import javax.annotation.Nonnull;

public interface INotifyService {
    public static final String MAIL_CHANNEL = "mail";
    public static final String PRIVATE_FEED_CHANNEL = "private-feed";
    public static final String PUBLIC_FEED_CHANNEL = "public-feed";
    public static final Param<Object> NOTIFICATION = Param.pObject("notification");
    public static final Param<Object> PREFERENCES = Param.pObject("preferences");
    public static final Param<Object> CHANNEL_PREFERENCES = Param.pObject("channelPreferences");
    public static final Param<String> NOTIFY_UNKNOWN = Param.pString("unknown");
    public static final Param<String> CONFIRMATION_URL = Param.pString("confirmationUrl");
    public static final Param<Boolean> RENDER_MASTER_TEMPLATE = Param.pBoolean("renderMaster");

    public IPreferences getPreferences(@Nonnull String var1);

    @Nonnull
    public IPreferences newPreferences(@Nonnull String var1);

    public void setPreferences(@Nonnull IPreferences var1);

    public void removePreferences(@Nonnull String var1);

    public void notify(@Nonnull Notification var1);

    public void notifyNow(@Nonnull Notification var1) throws NotifyException;

    public void confirm(@Nonnull Notification var1);

    public void confirmNow(@Nonnull Notification var1) throws NotifyException;

    public void addErrorListener(@Nonnull IErrorListener var1);

    public void removeErrorListener(@Nonnull IErrorListener var1);

    public void addNotificationListener(@Nonnull INotificationListner var1);

    public void removeNotificationListener(@Nonnull INotificationListner var1);

    public void addConfirmationListener(@Nonnull IConfirmationListener var1);

    public void removeConfirmationListener(@Nonnull IConfirmationListener var1);

    public String toPullPath(String var1, String var2, IParams var3);

    public static class NotifyRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NotifyRuntimeException() {
        }

        public NotifyRuntimeException(String message, Throwable cause) {
            super(message, cause);
        }

        public NotifyRuntimeException(String message) {
            super(message);
        }

        public NotifyRuntimeException(Throwable cause) {
            super(cause);
        }
    }

    public static class NotifyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NotifyException() {
        }

        public NotifyException(String message, Throwable cause) {
            super(message, cause);
        }

        public NotifyException(String message) {
            super(message);
        }

        public NotifyException(Throwable cause) {
            super(cause);
        }
    }

    public static interface IParamsFactory {
        public void params(@Nonnull Params var1) throws NotifyException;
    }

    public static abstract class Utils {
        private Utils() {
        }

        public static void mailNow(INotifyService notifyService, Notification notification) throws NotifyException {
            Utils.notifyUnknownNow(notifyService, INotifyService.MAIL_CHANNEL, notification);
        }

        public static void mail(INotifyService notifyService, Notification notification) throws NotifyException {
            Utils.notifyUnknown(notifyService, INotifyService.MAIL_CHANNEL, notification);
        }

        public static void notifyUnknownNow(INotifyService notifyService, String channelId, Notification notification) throws NotifyException {
            notification.getParams().set(NOTIFY_UNKNOWN, channelId);
            notifyService.notifyNow(notification);
        }

        public static void notifyUnknown(INotifyService notifyService, String channelId, Notification notification) throws NotifyException {
            notification.getParams().set(NOTIFY_UNKNOWN, channelId);
            notifyService.notify(notification);
        }
    }

    public static interface IErrorListener {
        public void error(@Nonnull Notification var1, @Nonnull IPushChannel var2, @Nonnull IPushChannel.PushException var3);
    }

    public static interface IConfirmationListener {
        public String confirm(@Nonnull Notification var1);
    }

    public static interface INotificationListner {
        public void notification(@Nonnull Notification var1);
    }
}

