/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.channel.mail;

import at.molindo.notify.channel.mail.AbstractMailClient;
import at.molindo.notify.channel.mail.IMailClient;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class SimpleMailClient
extends AbstractMailClient
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SimpleMailClient.class);
    private String _server;
    private Integer _port;
    private String _user;
    private String _password;
    private AbstractMailClient.Security _security = AbstractMailClient.Security.NONE;
    private Session _smtpSession = null;
    private boolean _connect = true;
    private boolean _failOnConnectError = true;

    public SimpleMailClient() {
    }

    public SimpleMailClient(String server, String from) throws AddressException, IMailClient.MailException {
        this.setServer(server);
        this.setFrom(from);
        this.init();
    }

    @Override
    public SimpleMailClient init() throws IMailClient.MailException {
        super.init();
        if (this._smtpSession == null) {
            this._smtpSession = this.createSmtpSession();
            try {
                this.connectTransport();
            }
            catch (IMailClient.MailException e) {
                if (this._failOnConnectError) {
                    throw e;
                }
                log.warn("failed to connect transport", (Throwable)e);
            }
        }
        return this;
    }

    private Transport connectTransport() throws IMailClient.MailException {
        try {
            Transport t = this._smtpSession.getTransport("smtp");
            if (this.isConnect() && !t.isConnected()) {
                t.connect();
            }
            return t;
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("no SMTP provider?", e);
        }
        catch (MessagingException e) {
            throw new IMailClient.MailException("can't connect to SMTP server", e, true);
        }
    }

    protected Session createSmtpSession() {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", this._server);
        props.setProperty("mail.smtp.port", Integer.toString(this._port != null ? this._port.intValue() : this._security.getDefaultPort()));
        props.setProperty("mail.smtp.auth", Boolean.toString(this._user != null));
        if (this._security == AbstractMailClient.Security.TLS) {
            props.setProperty("mail.smtp.starttls.enable", "true");
        } else if (this._security == AbstractMailClient.Security.SSL) {
            props.put("mail.smtp.ssl", "true");
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        return Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                if (SimpleMailClient.this._user != null) {
                    return new PasswordAuthentication(SimpleMailClient.this._user, SimpleMailClient.this._password);
                }
                return null;
            }
        });
    }

    @Override
    protected Session getSmtpSession(String recipient) throws IMailClient.MailException {
        this.connectTransport();
        return this._smtpSession;
    }

    public String getServer() {
        return this._server;
    }

    public SimpleMailClient setServer(String server) {
        this._server = server;
        return this;
    }

    public Integer getPort() {
        return this._port;
    }

    public SimpleMailClient setPort(Integer port) {
        this._port = port;
        return this;
    }

    public String getUser() {
        return this._user;
    }

    public SimpleMailClient setUser(String user) {
        this._user = user;
        return this;
    }

    public String getPassword() {
        return this._password;
    }

    public SimpleMailClient setPassword(String password) {
        this._password = password;
        return this;
    }

    public AbstractMailClient.Security getSecurity() {
        return this._security;
    }

    public SimpleMailClient setSecurity(AbstractMailClient.Security security) {
        this._security = security;
        return this;
    }

    public boolean isConnect() {
        return this._connect;
    }

    public SimpleMailClient setConnect(boolean connect) {
        this._connect = connect;
        return this;
    }

    public boolean isFailOnConnectError() {
        return this._failOnConnectError;
    }

    public SimpleMailClient setFailOnConnectError(boolean failOnConnectError) {
        this._failOnConnectError = failOnConnectError;
        return this;
    }
}

