/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.servlet;

import at.molindo.notify.INotifyService;
import at.molindo.notify.channel.IPullChannel;
import at.molindo.notify.confirm.IConfirmationService;
import at.molindo.notify.model.Confirmation;
import at.molindo.notify.model.IChannelPreferences;
import at.molindo.notify.model.IParams;
import at.molindo.notify.model.IRequestConfigurable;
import at.molindo.notify.model.Notification;
import at.molindo.notify.model.ParamValue;
import at.molindo.notify.model.Params;
import at.molindo.notify.servlet.INotifyUrlFactory;
import at.molindo.utils.data.StringUtils;
import at.molindo.utils.io.CharsetUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.GenericFilterBean;

public class NotifyFilterBean
extends GenericFilterBean
implements INotifyUrlFactory {
    private static final Logger log = LoggerFactory.getLogger(NotifyFilterBean.class);
    static final String PARAMTER_BASE_URL_PROPERTY = "baseUrlProperty";
    static final String PARAMTER_BASE_URL = "baseUrl";
    static final String DEFAULT_MOUNT_PATH = "notify";
    static final String PARAMTER_MOUNT_PATH = "mountPath";
    static final String DEFAULT_PULL_PREFIX = "pull";
    static final String PARAMTER_PULL_PREFIX = "pullPrefix";
    static final String DEFAULT_CONFIRM_PREFIX = "confirm";
    static final String PARAMTER_CONFIRM_PREFIX = "confirmPrefix";
    private String _baseUrl;
    private String _baseUrlProperty;
    private String _mountPath;
    private String _pullPrefix;
    private Pattern _pullPattern;
    private String _confirmPrefix;
    private Pattern _confirmPattern;
    private final Map<String, IPullChannel> _channels = new HashMap<String, IPullChannel>();
    private IConfirmationService _confirmationService;

    public void initFilterBean() throws ServletException {
        String baseUrl;
        if (!StringUtils.empty((String)this._baseUrlProperty) && !StringUtils.empty((String)(baseUrl = System.getProperty(this._baseUrlProperty)))) {
            this._baseUrl = baseUrl;
        }
        if (StringUtils.empty((String)this._baseUrl)) {
            throw new ServletException(String.format("parameter %s is required", PARAMTER_BASE_URL));
        }
        try {
            this._baseUrl = StringUtils.stripTrailing((String)new URL(this._baseUrl).toString(), (String)"/");
        }
        catch (MalformedURLException e) {
            throw new ServletException(String.format("illegal value for parameter %s: '%s'", PARAMTER_BASE_URL, this._baseUrl), (Throwable)e);
        }
        if (StringUtils.empty((String)this._mountPath)) {
            this._mountPath = DEFAULT_MOUNT_PATH;
        }
        this._mountPath = StringUtils.stripTrailing((String)StringUtils.startWith((String)this._mountPath, (String)"/"), (String)"/");
        if (StringUtils.empty((String)this._pullPrefix)) {
            this._pullPrefix = DEFAULT_PULL_PREFIX;
        }
        this._pullPrefix = StringUtils.endWith((String)StringUtils.startWith((String)this._pullPrefix, (String)"/"), (String)"/");
        this._pullPattern = Pattern.compile("^" + Pattern.quote(this._pullPrefix) + "([^/?]+)/([^/?]+).*$");
        if (StringUtils.empty((String)this._confirmPrefix)) {
            this._confirmPrefix = DEFAULT_CONFIRM_PREFIX;
        }
        this._confirmPrefix = StringUtils.endWith((String)StringUtils.startWith((String)this._confirmPrefix, (String)"/"), (String)"/");
        this._confirmPattern = Pattern.compile("^" + Pattern.quote(this._confirmPrefix) + "([^/?]+)/?$");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path = request.getRequestURI();
        if (StringUtils.empty((String)path) || !path.startsWith(this._mountPath)) {
            response.sendError(404);
            return;
        }
        if ((path = path.substring(this._mountPath.length())).startsWith(this._pullPrefix)) {
            this.pull(request, response, path);
        } else if (path.startsWith(this._confirmPrefix)) {
            if (!this.confirm(request, response, path)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected void pull(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        block15: {
            Matcher m = this._pullPattern.matcher(path);
            if (!m.matches()) {
                response.sendError(404);
                return;
            }
            String channelId = this.decode(m.group(1));
            String userId = this.decode(m.group(2));
            if (StringUtils.empty((String)userId) || StringUtils.empty((String)channelId)) {
                response.sendError(404);
                return;
            }
            IPullChannel channel = this.getChannel(channelId);
            if (channel == null) {
                response.sendError(404);
                return;
            }
            IChannelPreferences prefs = channel.newDefaultPreferences();
            if (prefs instanceof IRequestConfigurable) {
                try {
                    Map queryParams = request.getParameterMap();
                    for (Map.Entry e : queryParams.entrySet()) {
                        Object value = e.getValue();
                        if (value != null && value.getClass().isArray()) {
                            String[] vals = (String[])value;
                            value = vals.length > 0 ? vals[0] : null;
                        }
                        ((IRequestConfigurable)((Object)prefs)).setParam((String)e.getKey(), (String)value);
                    }
                }
                catch (INotifyService.NotifyException e) {
                    response.sendError(404);
                    return;
                }
            }
            if (channel.getNotificationTypes().contains((Object)Notification.Type.PRIVATE) && !channel.isAuthorized(userId, prefs)) {
                response.sendError(403);
            } else if (channel.isConfigured(new Params(prefs.getParams()))) {
                try {
                    String output = channel.pull(userId, prefs);
                    if (StringUtils.empty((String)output)) {
                        response.sendError(404);
                        break block15;
                    }
                    response.getWriter().write(output);
                }
                catch (IPullChannel.PullException e) {
                    log.info("failed to pull notifications", (Throwable)e);
                    response.sendError(500);
                }
            } else {
                response.sendError(404);
            }
        }
    }

    protected boolean confirm(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, ServletException {
        Matcher m = this._confirmPattern.matcher(path);
        if (!m.matches()) {
            return false;
        }
        String key = this.decode(m.group(1));
        try {
            String confirmPath = this._confirmationService.confirm(key);
            if (confirmPath != null) {
                response.sendRedirect(confirmPath);
            } else {
                response.sendError(404);
            }
            return true;
        }
        catch (IConfirmationService.ConfirmationException e) {
            return false;
        }
    }

    private String decode(String string) {
        try {
            return URLDecoder.decode(string, CharsetUtils.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported?", e);
        }
    }

    private String encode(String string) {
        try {
            return URLEncoder.encode(string, CharsetUtils.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported?", e);
        }
    }

    private IPullChannel getChannel(String channelId) {
        return this._channels.get(channelId);
    }

    @Override
    public String toPullPath(String channelId, String userId, IParams params) {
        IPullChannel channel = this.getChannel(channelId);
        if (channel == null) {
            return null;
        }
        IChannelPreferences cPrefs = channel.newDefaultPreferences();
        IParams fullParams = new Params().setAll(cPrefs.getParams()).setAll(params);
        StringBuilder buf = new StringBuilder(this._baseUrl);
        buf.append(this._mountPath).append(this._pullPrefix).append(channelId).append("/").append(userId);
        buf.append("?");
        for (ParamValue pv : fullParams) {
            String encodedName = this.encode(pv.getName());
            String value = pv.getStringValue();
            String encodedValue = value != null ? this.encode(value) : "";
            buf.append(encodedName);
            buf.append("=");
            buf.append(encodedValue);
            buf.append("&");
        }
        buf.setLength(buf.length() - 1);
        return buf.toString();
    }

    @Override
    public String toConfirmPath(Confirmation confirmation) {
        return this._baseUrl + this._mountPath + this._confirmPrefix + confirmation.getKey();
    }

    public String getBaseUrl() {
        return this._baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this._baseUrl = baseUrl;
    }

    public String getBaseUrlProperty() {
        return this._baseUrlProperty;
    }

    public void setBaseUrlProperty(String baseUrlProperty) {
        this._baseUrlProperty = baseUrlProperty;
    }

    public String getMountPath() {
        return this._mountPath;
    }

    public void setMountPath(String mountPath) {
        this._mountPath = mountPath;
    }

    public String getPullPrefix() {
        return this._pullPrefix;
    }

    public void setPullPrefix(String pullPrefix) {
        this._pullPrefix = pullPrefix;
    }

    public String getConfirmPrefix() {
        return this._confirmPrefix;
    }

    public void setConfirmPrefix(String confirmPrefix) {
        this._confirmPrefix = confirmPrefix;
    }

    public void setChannels(Set<IPullChannel> channels) {
        this._channels.clear();
        for (IPullChannel channel : channels) {
            this._channels.put(channel.getId(), channel);
        }
    }

    public void setConfirmationService(IConfirmationService confirmationService) {
        this._confirmationService = confirmationService;
    }
}

