/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.model;

import at.molindo.notify.INotifyService;
import at.molindo.notify.model.IParams;
import at.molindo.notify.model.Param;
import at.molindo.notify.model.ParamValue;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;

public class BeanParams<B>
implements IParams {
    private final B _bean;

    public static <B> BeanParams<B> params(B bean) {
        return new BeanParams<B>(bean);
    }

    public BeanParams(B bean) {
        if (bean == null) {
            throw new NullPointerException("bean");
        }
        this._bean = bean;
    }

    public B getBean() {
        return this._bean;
    }

    @Override
    public <T> IParams set(Param<T> param, T value) {
        this.setProperty(param, value);
        return this;
    }

    @Override
    public <T> T get(Param<T> param) {
        Object o = this.getProperty(param.getName());
        if (o == null) {
            return null;
        }
        if (param.getType().isAssignableFrom(o.getClass())) {
            return param.getType().cast(o);
        }
        if (o instanceof String) {
            return param.toObject((String)o);
        }
        return param.toObject(param.toString(o));
    }

    @Override
    public boolean isSet(Param<?> param) {
        return this.getProperty(param.getName()) != null;
    }

    @Override
    public Iterator<ParamValue> iterator() {
        return new Iterator<ParamValue>(){
            private final Iterator<PropertyDescriptor> _iter;
            private ParamValue _next;
            {
                this._iter = BeanParams.this.getDescriptorsIter();
                this._next = this.findNext();
            }

            private ParamValue findNext() {
                while (this._iter.hasNext()) {
                    Object value;
                    PropertyDescriptor pd = this._iter.next();
                    if (pd.getWriteMethod() == null || pd.getReadMethod() == null || (value = BeanParams.this.invoke(pd.getReadMethod(), new Object[0])) == null) continue;
                    return Param.p(pd.getPropertyType(), pd.getName()).paramValue(value);
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this._next != null;
            }

            @Override
            public ParamValue next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ParamValue next = this._next;
                this._next = this.findNext();
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean containsAll(Param<?> ... params) {
        return IParams.Util.containsAll(this, params);
    }

    @Override
    public IParams setAll(IParams params) {
        IParams.Util.setAll(this, params);
        return this;
    }

    @Override
    public Map<String, Object> newMap() {
        return IParams.Util.newMap(this);
    }

    private PropertyDescriptor getDescriptor(String propertyName) {
        try {
            PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor(this._bean, (String)propertyName);
            return pd != null && pd.getWriteMethod() != null && pd.getReadMethod() != null ? pd : null;
        }
        catch (IllegalAccessException e) {
            throw new INotifyService.NotifyRuntimeException("failed to get PropertyDescriptor for property " + propertyName + " from bean " + this._bean, e);
        }
        catch (InvocationTargetException e) {
            throw new INotifyService.NotifyRuntimeException("failed to get PropertyDescriptor for property " + propertyName + " from bean " + this._bean, e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Iterator<PropertyDescriptor> getDescriptorsIter() {
        return Arrays.asList(PropertyUtils.getPropertyDescriptors(this._bean)).iterator();
    }

    private Object getProperty(String name) {
        try {
            return BeanUtils.getProperty(this._bean, (String)name);
        }
        catch (IllegalAccessException e) {
            throw new INotifyService.NotifyRuntimeException("failed to get property " + name + " from bean " + this._bean, e);
        }
        catch (InvocationTargetException e) {
            throw new INotifyService.NotifyRuntimeException("failed to get property " + name + " from bean " + this._bean, e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Object invoke(Method m, Object ... args) {
        try {
            return m.invoke(this._bean, args);
        }
        catch (IllegalArgumentException e) {
            throw new INotifyService.NotifyRuntimeException("failed to invoke method " + m + " on " + this._bean, e);
        }
        catch (IllegalAccessException e) {
            throw new INotifyService.NotifyRuntimeException("failed to invoke method " + m + " on " + this._bean, e);
        }
        catch (InvocationTargetException e) {
            throw new INotifyService.NotifyRuntimeException("failed to invoke method " + m + " on " + this._bean, e);
        }
    }

    private void setProperty(Param<?> param, Object value) {
        PropertyDescriptor pd = this.getDescriptor(param.getName());
        if (pd == null) {
            return;
        }
        Object converted = value == null || pd.getPropertyType().isAssignableFrom(value.getClass()) ? value : Param.p(pd.getPropertyType(), pd.getName()).toObject(param.toString(value));
        try {
            PropertyUtils.setProperty(this._bean, (String)param.getName(), (Object)converted);
        }
        catch (NoSuchMethodException e) {
            throw new INotifyService.NotifyRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new INotifyService.NotifyRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new INotifyService.NotifyRuntimeException(e);
        }
    }
}

