/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.render;

import at.molindo.notify.INotifyService;
import at.molindo.notify.model.IParams;
import at.molindo.notify.model.Message;
import at.molindo.notify.model.Param;
import at.molindo.notify.model.Params;
import at.molindo.notify.render.IRenderService;
import at.molindo.utils.data.StringUtils;

public class MasterRenderService
implements IRenderService {
    public static final String DEFAULT_TEMPLATE_KEY = "masterTemplate";
    public static final String DEFAULT_TEMPLATE_CONTENT = "message";
    private IRenderService _renderService;
    private String _masterTemplateKey = "masterTemplate";
    private String _masterTemplateMessage = "message";
    private IParams _masterParams;

    @Override
    public Message render(String key, IRenderService.Version version, IParams params) throws IRenderService.RenderException {
        Message m;
        Message mRaw = this._renderService.render(key, version, params);
        Params masterParams = new Params();
        if (this._masterParams != null) {
            masterParams.setAll(this._masterParams);
        }
        masterParams.set(this.getMasterTemplateMessageParam(), mRaw);
        Boolean renderMaster = params.get(INotifyService.RENDER_MASTER_TEMPLATE);
        if (!Boolean.FALSE.equals(renderMaster)) {
            m = this._renderService.render(this._masterTemplateKey, version, masterParams);
            if (StringUtils.empty((String)m.getSubject()) && !StringUtils.empty((String)mRaw.getSubject())) {
                m.setSubject(mRaw.getSubject());
            }
        } else {
            m = mRaw;
        }
        return m;
    }

    public void setRenderService(IRenderService renderService) {
        this._renderService = renderService;
    }

    public String getMasterTemplateKey() {
        return this._masterTemplateKey;
    }

    public void setMasterTemplateKey(String masterTemplateKey) {
        if (StringUtils.empty((String)masterTemplateKey)) {
            throw new IllegalArgumentException("masterTemplateKey must not be empty");
        }
        this._masterTemplateKey = masterTemplateKey;
    }

    public Param<Object> getMasterTemplateMessageParam() {
        return Param.pObject(this._masterTemplateMessage);
    }

    public void setMasterTemplateMessage(String masterTemplateMessage) {
        this._masterTemplateMessage = masterTemplateMessage;
    }

    public IParams getMasterParams() {
        return this._masterParams;
    }

    public void setMasterParams(IParams masterParams) {
        this._masterParams = masterParams;
    }
}

