/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.model;

import at.molindo.notify.channel.feed.AbstractPullChannel;
import at.molindo.notify.model.IPreferences;
import at.molindo.notify.model.IPushChannelPreferences;
import at.molindo.notify.model.Params;
import at.molindo.notify.model.PushChannelPreferences;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;

public class Preferences
implements IPreferences {
    private Long _id;
    private String _userId;
    private Params _params = new Params();
    private Map<String, IPushChannelPreferences> _channelPrefs = Maps.newHashMap();

    public Long getId() {
        return this._id;
    }

    public Preferences setId(Long id) {
        this._id = id;
        return this;
    }

    public String getUserId() {
        return this._userId;
    }

    public Preferences setUserId(String userId) {
        this._userId = userId;
        return this;
    }

    @Override
    public Map<String, IPushChannelPreferences> getChannelPrefs() {
        return this._channelPrefs;
    }

    protected Preferences setChannelPrefs(Map<String, IPushChannelPreferences> channelPrefs) {
        if (channelPrefs == null) {
            throw new NullPointerException("channelPrefs");
        }
        this._channelPrefs = channelPrefs;
        return this;
    }

    public Preferences addChannelPrefs(String channelId, PushChannelPreferences cPrefs) {
        this._channelPrefs.put(channelId, cPrefs);
        return this;
    }

    @Override
    public Params getParams() {
        return this._params;
    }

    protected Preferences setParams(Params params) {
        if (params == null) {
            throw new NullPointerException("params");
        }
        this._params = params;
        return this;
    }

    public Preferences generateSecret() {
        this._params.set(AbstractPullChannel.SECRET, UUID.randomUUID().toString());
        return this;
    }

    @Override
    public Preferences clone() {
        try {
            Preferences p = (Preferences)super.clone();
            p._params = this._params.clone();
            p._channelPrefs = Maps.newHashMap();
            for (Map.Entry<String, IPushChannelPreferences> e : this._channelPrefs.entrySet()) {
                p._channelPrefs.put(e.getKey(), e.getValue().clone());
            }
            return p;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("clone object not supported?", e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getChannelPrefs() == null ? 0 : this.getChannelPrefs().size());
        result = 31 * result + (this.getUserId() == null ? 0 : this.getUserId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Preferences)) {
            return false;
        }
        Preferences other = (Preferences)obj;
        if (this.getUserId() == null ? other.getUserId() != null : !this.getUserId().equals(other.getUserId())) {
            return false;
        }
        if (this.getParams() == null ? other.getParams() != null : !this.getParams().equals(other.getParams())) {
            return false;
        }
        return !(this.getChannelPrefs() == null ? other.getChannelPrefs() != null : !this.getChannelPrefs().equals(other.getChannelPrefs()));
    }

    public String toString() {
        return "Preferences [userId=" + this.getUserId() + "]";
    }
}

