/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.model;

import at.molindo.notify.model.Confirmation;
import at.molindo.notify.model.IParams;
import at.molindo.notify.model.Param;
import at.molindo.notify.model.Params;
import at.molindo.notify.model.PushState;
import com.google.common.collect.ImmutableSet;
import java.util.Date;

public class Notification {
    private Long _id;
    private String _userId;
    private String _key;
    private Type _type = Type.PRIVATE;
    private Date _date = new Date();
    private IParams _params = new Params();
    private Confirmation _confirmation;
    private PushState _pushState = PushState.QUEUED;
    private Date _pushDate = new Date();
    private int _pushErrors = 0;
    private String _pushErrorMessage;

    public Long getId() {
        return this._id;
    }

    public void setId(Long id) {
        this._id = id;
    }

    public String getUserId() {
        return this._userId;
    }

    public Notification setUserId(String userId) {
        this._userId = userId;
        return this;
    }

    public String getKey() {
        return this._key;
    }

    public Notification setKey(String key) {
        this._key = key;
        return this;
    }

    public Type getType() {
        return this._type;
    }

    public Notification setType(Type type) {
        this._type = type;
        return this;
    }

    public Date getDate() {
        return this._date;
    }

    public Notification setDate(Date date) {
        this._date = date;
        return this;
    }

    public IParams getParams() {
        return this._params;
    }

    protected Notification setParams(IParams params) {
        if (params == null) {
            throw new NullPointerException("params");
        }
        this._params = params;
        return this;
    }

    public <T> Notification setParam(Param<T> param, T value) {
        this.getParams().set(param, value);
        return this;
    }

    public Confirmation getConfirmation() {
        return this._confirmation;
    }

    public Notification setConfirmation(Confirmation confirmation) {
        this._confirmation = confirmation;
        if (this._confirmation != null && this._confirmation.getNotification() != this) {
            this._confirmation.setNotification(this);
        }
        return this;
    }

    public PushState getPushState() {
        return this._pushState;
    }

    public Notification setPushState(PushState pushState) {
        if (pushState == null) {
            throw new NullPointerException("pushState");
        }
        this._pushState = pushState;
        return this;
    }

    public Date getPushDate() {
        return this._pushDate;
    }

    public Notification setPushDate(Date pushDate) {
        this._pushDate = pushDate;
        return this;
    }

    public int getPushErrors() {
        return this._pushErrors;
    }

    Notification setPushErrors(int pushErrors) {
        this._pushErrors = pushErrors;
        return this;
    }

    public int recordPushError(String message) {
        this.setPushErrorMessage(message);
        return ++this._pushErrors;
    }

    public String getPushErrorMessage() {
        return this._pushErrorMessage;
    }

    public Notification setPushErrorMessage(String pushErrorMessage) {
        this._pushErrorMessage = pushErrorMessage;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getDate() == null ? 0 : this.getDate().hashCode());
        result = 31 * result + (this.getKey() == null ? 0 : this.getKey().hashCode());
        result = 31 * result + (this.getType() == null ? 0 : this.getType().hashCode());
        result = 31 * result + (this.getUserId() == null ? 0 : this.getUserId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)obj;
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.getDate() == null ? other.getDate() != null : !this.getDate().equals(other.getDate())) {
            return false;
        }
        if (this.getKey() == null ? other.getKey() != null : !this.getKey().equals(other.getKey())) {
            return false;
        }
        if (this.getParams() == null ? other.getParams() != null : !this.getParams().equals(other.getParams())) {
            return false;
        }
        return !(this.getUserId() == null ? other.getUserId() != null : !this.getUserId().equals(other.getUserId()));
    }

    public String toString() {
        return "Notification [userId=" + this._userId + ", key=" + this._key + ", type=" + (Object)((Object)this._type) + ", date=" + this._date + "]";
    }

    public static enum Type {
        PUBLIC,
        PRIVATE;

        public static ImmutableSet<Type> TYPES_ALL;
        public static ImmutableSet<Type> TYPES_PUBLIC;
        public static ImmutableSet<Type> TYPES_PRIVATE;

        static {
            TYPES_ALL = ImmutableSet.copyOf((Object[])Type.values());
            TYPES_PUBLIC = ImmutableSet.of((Object)((Object)PUBLIC));
            TYPES_PRIVATE = ImmutableSet.of((Object)((Object)PRIVATE));
        }
    }
}

