/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.model;

import at.molindo.notify.render.IRenderService;
import at.molindo.notify.util.NotifyUtils;
import at.molindo.utils.data.StringUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;

public class Message {
    private static final String FIELD_SUBJECT = "Subject";
    private static final ImmutableSet<String> REQUIRED_FIELDS = ImmutableSet.of((Object)"Subject");
    private static final ImmutableSet<String> SUPPORTED_FIELDS = ImmutableSet.of((Object)"Subject");
    private IRenderService.Type _type = IRenderService.Type.HTML;
    private String _subject;
    private String _message;

    public static Message parse(String str, IRenderService.Type type) throws IRenderService.RenderException {
        HashSet required = Sets.newHashSet(REQUIRED_FIELDS);
        HashMap fieldValues = Maps.newHashMap();
        Message rendered = new Message();
        rendered.setType(type);
        StringBuilder body = null;
        for (String line : StringUtils.split((String)str, (String)"\n")) {
            if (body == null) {
                if (StringUtils.empty((String)StringUtils.trim((String)line))) {
                    body = new StringBuilder();
                    continue;
                }
                int split = line.indexOf(58);
                if (split < 0) {
                    throw new IRenderService.RenderException("illegal line: " + line);
                }
                String fieldName = line.substring(0, split).trim();
                String fieldValue = line.substring(split + 1).trim();
                if (!SUPPORTED_FIELDS.contains((Object)fieldName)) {
                    throw new IRenderService.RenderException("unknown field: " + fieldName);
                }
                fieldValues.put(fieldName, fieldValue);
                continue;
            }
            if (body.length() <= 0 && StringUtils.empty((String)StringUtils.trim((String)line))) continue;
            body.append(line).append("\n");
        }
        required.removeAll(fieldValues.keySet());
        if (required.size() > 0) {
            throw new IRenderService.RenderException("missing fields: " + required);
        }
        if (body == null || body.length() == 0) {
            throw new IRenderService.RenderException("empty body");
        }
        body.setLength(body.length() - 1);
        rendered.setSubject((String)fieldValues.get(FIELD_SUBJECT));
        rendered.setMessage(body.toString());
        return rendered;
    }

    public Message() {
    }

    public Message(String subject, String message, IRenderService.Type type) {
        this.setType(type);
        this.setSubject(subject);
        this.setMessage(message);
    }

    public IRenderService.Type getType() {
        return this._type;
    }

    public void setType(IRenderService.Type type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this._type = type;
    }

    public String getSubject() {
        return this._subject;
    }

    public void setSubject(String subject) {
        this._subject = subject;
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public String getText() {
        if (this.getType() == IRenderService.Type.HTML) {
            return NotifyUtils.html2text(this.getMessage());
        }
        return this.getMessage();
    }

    public String getHtml() {
        if (this.getType() == IRenderService.Type.TEXT) {
            return NotifyUtils.text2html(this.getMessage());
        }
        return this.getMessage();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getSubject() == null ? 0 : this.getSubject().hashCode());
        result = 31 * result + (this.getType() == null ? 0 : this.getType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.getSubject() == null ? other.getSubject() != null : !this.getSubject().equals(other.getSubject())) {
            return false;
        }
        return !(this.getMessage() == null ? other.getMessage() != null : !this.getMessage().equals(other.getMessage()));
    }

    public String toString() {
        return "Message [type=" + (Object)((Object)this.getType()) + ", subject=" + this.getSubject() + ", message=" + this.getMessage() + "]";
    }
}

