/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.channel.mail;

import at.molindo.notify.channel.mail.IMailClient;
import at.molindo.notify.channel.mail.MailChannel;
import at.molindo.notify.model.Dispatch;
import at.molindo.utils.data.StringUtils;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.beans.factory.InitializingBean;

public class PatternMailClient
implements IMailClient,
InitializingBean {
    private IMailClient _defaultClient;
    private IMailClient _alternativeClient;
    private Pattern[] _clientPatterns = new Pattern[0];

    public void afterPropertiesSet() throws Exception {
        if (this._defaultClient == null) {
            throw new IllegalStateException("defaultClient not configured");
        }
        if (this._clientPatterns.length > 0 && this._alternativeClient == null) {
            throw new IllegalStateException("clientPatterns but no alternativeClient configured");
        }
    }

    @Override
    public void send(Dispatch dispatch) throws IMailClient.MailException {
        this.getClient(this.getServer(dispatch.getParams().get(MailChannel.RECIPIENT))).send(dispatch);
    }

    String getServer(String recipient) {
        return StringUtils.empty((String)recipient) ? "" : StringUtils.afterLast((String)recipient, (String)"@");
    }

    IMailClient getClient(String server) {
        if (!StringUtils.empty((String)server)) {
            for (Pattern p : this._clientPatterns) {
                if (!p.matcher(server).find()) continue;
                return this._alternativeClient;
            }
        }
        return this._defaultClient;
    }

    public void setClientPatterns(List<String> smartClientPatterns) {
        this._clientPatterns = new Pattern[smartClientPatterns.size()];
        for (int i = 0; i < this._clientPatterns.length; ++i) {
            this._clientPatterns[i] = Pattern.compile(smartClientPatterns.get(i), 2);
        }
    }

    public void setDefaultClient(IMailClient defaultClient) {
        this._defaultClient = defaultClient;
    }

    public void setAlternativeClient(IMailClient alternativeClient) {
        this._alternativeClient = alternativeClient;
    }

    protected IMailClient getDefaultClient() {
        return this._defaultClient;
    }

    protected IMailClient getAlternativeClient() {
        return this._alternativeClient;
    }
}

