/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.notify.channel.feed;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedInput;
import com.sun.syndication.io.WireFeedOutput;
import java.io.Reader;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class FeedUtils {
    private FeedUtils() {
    }

    public static String toFeedXml(WireFeed feed) throws FeedException {
        return FeedUtils.toFeedXml(feed, false);
    }

    public static String toFeedXml(WireFeed feed, boolean debug) throws FeedException {
        if (feed instanceof Feed) {
            if (((Feed)feed).getTitle() == null) {
                throw new IllegalArgumentException("feed title must be set");
            }
            if (((Feed)feed).getUpdated() == null) {
                throw new IllegalArgumentException("feed updated must be set");
            }
        } else if (feed instanceof Channel && ((Channel)feed).getTitle() == null) {
            throw new IllegalArgumentException("feed title must be set");
        }
        Document doc = new WireFeedOutput().outputJDom(feed);
        Format format = debug ? Format.getPrettyFormat() : Format.getRawFormat();
        format.setOmitDeclaration(true);
        format.setOmitEncoding(true);
        XMLOutputter outputter = new XMLOutputter(format);
        return outputter.outputString(doc);
    }

    public static Feed fromFeedXml(String feedXml) throws FeedException {
        return (Feed)new WireFeedInput(false).build((Reader)new StringReader(feedXml));
    }
}

