/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.mysqlcollations;

import at.molindo.mysqlcollations.MySqlCharacterMap;
import at.molindo.mysqlcollations.MySqlCharset;
import at.molindo.mysqlcollations.MySqlCharsets;
import at.molindo.mysqlcollations.MySqlCollation;
import at.molindo.mysqlcollations.MySqlCollator;
import at.molindo.utils.properties.SystemProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MySqlCollatorFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CHARSETS = "charsets";
    private static final String CHARSET = "charsets/charset";
    private static final String COLLATION = "charsets/charset/collation";
    private static final String PROPERTY_BASE = MySqlCollatorFactory.class.getPackage().getName();
    private static final String PROPERTY_MYSQL_DIR = PROPERTY_BASE + ".mySqlDir";
    private static final String PROPERTY_MYSQL_HOME_DIR = PROPERTY_BASE + ".mySqlHomeDir";
    public static final String CHARSET_LATIN1 = "latin1";
    public static final String COLLATION_LATIN1_SWEDISH_CI = "latin1_swedish_ci";
    public static final String CHARSET_DEFAULT = "latin1";
    public static final String COLLATION_DEFAULT = "latin1_swedish_ci";
    public static final String CHARSET_DIR = "/usr/share/mysql/charsets";
    private MySqlCharsets _charsets;

    public static MySqlCollatorFactory parse(String path) throws IOException, SAXException {
        return MySqlCollatorFactory.parse(new File(path));
    }

    public static MySqlCollatorFactory parse(File collation) throws IOException, SAXException {
        return MySqlCollatorFactory.parse(new FileInputStream(collation));
    }

    public static MySqlCollatorFactory parse(URL collation) throws IOException, SAXException {
        return MySqlCollatorFactory.parse(collation.openStream());
    }

    public static MySqlCollatorFactory parse(InputStream in) throws IOException, SAXException {
        return MySqlCollatorFactory.parse(new InputSource(in));
    }

    public static MySqlCollatorFactory parse(Reader reader) throws IOException, SAXException {
        return MySqlCollatorFactory.parse(new InputSource(reader));
    }

    public static MySqlCollatorFactory parseDirectory(String path) throws IOException, SAXException {
        return MySqlCollatorFactory.parseDirectory(new File(path));
    }

    public static MySqlCollatorFactory parseDirectory(File dir) throws IOException, SAXException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("not a directory = " + dir);
        }
        MySqlCollatorFactory factory = null;
        for (File file : dir.listFiles(new CharsetFileFilter())) {
            MySqlCollatorFactory current = MySqlCollatorFactory.parse(file);
            if (factory == null) {
                factory = current;
                continue;
            }
            factory.addCharsets(current);
        }
        return factory;
    }

    public static boolean isValidCharsetDirectory() {
        return MySqlCollatorFactory.getDirectory().isDirectory();
    }

    public static MySqlCollatorFactory parseDefaultDirectory() throws IOException, SAXException {
        File dir = MySqlCollatorFactory.getDirectory();
        if (dir.isDirectory()) {
            return MySqlCollatorFactory.parseDirectory(dir);
        }
        if ("windows".equals(SystemProperty.OS_FAMILY.get())) {
            throw new RuntimeException(String.format("%s ist not a directory, please check your %s system property (current value %s) for a valid MySQL charsets directory", dir, PROPERTY_MYSQL_HOME_DIR, System.getProperty(PROPERTY_MYSQL_HOME_DIR)));
        }
        throw new RuntimeException(String.format("%s ist not a directory, please check your %s system property (current value %s) for a valid MySQL charsets directory", dir, PROPERTY_MYSQL_DIR, System.getProperty(PROPERTY_MYSQL_DIR)));
    }

    private static File getDirectory() {
        String os = SystemProperty.OS_FAMILY.get();
        if ("windows".equals(os)) {
            return new File(System.getProperties().getProperty(PROPERTY_MYSQL_HOME_DIR, "C:\\Programme\\MySQL\\MySQL Server 5.0") + "\\share\\charsets");
        }
        return new File(System.getProperties().getProperty(PROPERTY_MYSQL_DIR, "mac".equals(os) ? "/usr/local/mysql/share/charsets" : CHARSET_DIR));
    }

    public static MySqlCollatorFactory parse(InputSource source) throws IOException, SAXException {
        Digester digester = MySqlCollatorFactory.newDigester();
        MySqlCharsets charsets = (MySqlCharsets)digester.parse(source);
        return new MySqlCollatorFactory(charsets);
    }

    private static Digester newDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setNamespaceAware(false);
        digester.addObjectCreate(CHARSETS, MySqlCharsets.class);
        digester.addBeanPropertySetter("charsets/copyright");
        digester.addObjectCreate(CHARSET, MySqlCharset.class);
        digester.addSetProperties(CHARSET);
        digester.addSetNext(CHARSET, "add");
        for (String map : new String[]{"ctype", "lower", "upper", "unicode"}) {
            String element = "charsets/charset/" + map;
            digester.addObjectCreate(element, MySqlCharacterMap.class);
            digester.addBeanPropertySetter(element + "/map");
            digester.addSetNext(element, "set" + map.substring(0, 1).toUpperCase() + map.substring(1));
        }
        digester.addObjectCreate(COLLATION, MySqlCollation.class);
        digester.addSetProperties(COLLATION);
        digester.addBeanPropertySetter("charsets/charset/collation/map");
        digester.addSetNext(COLLATION, "add");
        return digester;
    }

    private MySqlCollatorFactory(MySqlCharsets charsets) {
        this._charsets = charsets;
    }

    public MySqlCollator getCollator(String charset, String collation) {
        MySqlCharset cset = this._charsets.getCharsets().get(charset);
        if (cset == null) {
            throw new IllegalArgumentException("charset not available: " + charset);
        }
        MySqlCollation coll = cset.getCollations().get(collation);
        if (coll == null) {
            throw new IllegalArgumentException("collation not available for charset '" + charset + "': " + collation);
        }
        return coll.getCollatorInstance();
    }

    public MySqlCollator getDefaultCollator() {
        return this.getCollator("latin1", "latin1_swedish_ci");
    }

    private void addCharsets(MySqlCollatorFactory current) {
        this._charsets = new MySqlCharsets(this._charsets, current._charsets);
    }

    private static class CharsetFileFilter
    implements FilenameFilter {
        private CharsetFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".xml") && !"Index.xml".equals(name);
        }
    }
}

