/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.mysqlcollations;

import at.molindo.mysqlcollations.MySqlCharacterMap;
import at.molindo.mysqlcollations.MySqlCharset;
import at.molindo.mysqlcollations.MySqlCollator;
import java.io.Serializable;

public class MySqlCollation
extends MySqlCharacterMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _name;
    private String _flag;
    private MySqlCharset _charset;
    private MySqlCollator _collator;
    private volatile char[] _normalize;

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getFlag() {
        return this._flag;
    }

    public void setFlag(String flag) {
        this._flag = flag;
    }

    public MySqlCharset getCharset() {
        return this._charset;
    }

    public void setCharset(MySqlCharset charset) {
        this._charset = charset;
    }

    public String toString() {
        return "Collation [_name=" + this._name + ", _flag=" + this._flag + "]";
    }

    public MySqlCollator getCollatorInstance() {
        if (this._collator == null) {
            this._collator = new MySqlCollator(this);
        }
        return this._collator;
    }

    public byte getWeight(char character) {
        return (byte)this.getValue(this.getCharset().toIndex(character));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] getNormalize() {
        if (this._normalize == null) {
            MySqlCollation mySqlCollation = this;
            synchronized (mySqlCollation) {
                if (this._normalize == null) {
                    this._normalize = new char[this.getValues().length];
                    char[] characters = this.getCharset().getCharacters();
                    for (int i = 0; i < characters.length; ++i) {
                        char c = characters[i];
                        int index = this.getWeight(c) & 0xFF;
                        char current = this._normalize[index];
                        if (current != '\u0000' && current <= c) continue;
                        this._normalize[index] = c;
                    }
                }
            }
        }
        return this._normalize;
    }

    public String normalize(String string) {
        if (string == null) {
            return null;
        }
        char[] normalize = this.getNormalize();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            buf.append(normalize[this.getWeight(string.charAt(i)) & 0xFF]);
        }
        return buf.toString();
    }
}

