/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.mysqlcollations;

import java.io.Serializable;

public class MySqlCharacterMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _map;
    private transient int[] _values;

    public String getMap() {
        return this._map;
    }

    public void setMap(String map) {
        this._map = map;
        this._values = null;
    }

    protected int[] getValues() {
        if (this._values == null && this._map != null) {
            this._values = this.parseMapValues(this._map);
        }
        return this._values;
    }

    public int getValue(int index) {
        if (this._map == null) {
            throw new IllegalStateException("no map set");
        }
        int[] values = this.getValues();
        if (index < 0 || index >= values.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return values[index];
    }

    private int[] parseMapValues(String map) {
        if (map == null) {
            return null;
        }
        String[] str = map.split("\\s+");
        int[] values = new int[str.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Integer.parseInt(str[i], 16);
        }
        return values;
    }
}

