/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.mysqlcollations.lib;

import at.molindo.mysqlcollations.lib.Collation;
import at.molindo.utils.collections.CollectionUtils;
import at.molindo.utils.collections.IteratorUtils;
import at.molindo.utils.data.Function;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollationList {
    private static final Logger log = LoggerFactory.getLogger(CollationList.class);
    private static final String COLLATION_PROPERTIES_FILE = "/collations.properties";
    private static final List<Collation> COLLATIONS;
    public static final int MAX_INDEX;

    private CollationList() {
    }

    static Collation collation(int index) {
        return index < 0 || index > MAX_INDEX ? null : COLLATIONS.get(index);
    }

    static Iterator<Collation> iterator() {
        return IteratorUtils.filter(COLLATIONS.iterator(), (Function)new Function<Collation, Boolean>(){

            public Boolean apply(Collation input) {
                return input != null;
            }
        });
    }

    static {
        try {
            Properties props = new Properties();
            props.load(CollationList.class.getResourceAsStream(COLLATION_PROPERTIES_FILE));
            ArrayList collations = new ArrayList(256);
            boolean addAllCollations = Boolean.getBoolean(System.getProperty(Collation.PROP_LIB_COLLATION_COMPARE_ALL));
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                String name;
                int idx = Integer.parseInt((String)e.getKey());
                Collation collation = new Collation(idx, name = (String)e.getValue());
                if (collation.getCharset() != null) {
                    CollectionUtils.set(collations, (int)idx, (Object)collation);
                    continue;
                }
                if (addAllCollations) {
                    log.info("adding collation without charset: " + collation.getName());
                    CollectionUtils.set(collations, (int)idx, (Object)collation);
                    continue;
                }
                log.debug("ignoring collation withough mapped charset: " + collation.getName());
            }
            COLLATIONS = Collections.unmodifiableList(collations);
            MAX_INDEX = collations.size() - 1;
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load properties from /collations.properties", e);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("failed to load properties from /collations.properties", e);
        }
    }
}

