/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.spotify.helios.cli.Target;
import com.spotify.helios.cli.Utils;
import com.spotify.helios.cli.command.CliCommand;
import com.spotify.helios.cli.command.TargetAndClient;
import com.spotify.helios.client.HeliosClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public abstract class MultiTargetControlCommand
implements CliCommand {
    MultiTargetControlCommand(Subparser parser) {
        parser.setDefault("command", (Object)this).defaultHelp(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(Namespace options, List<Target> targets, PrintStream out, PrintStream err, String username, boolean json, BufferedReader stdin) throws IOException, InterruptedException {
        int result;
        ImmutableList.Builder clientBuilder = ImmutableList.builder();
        for (Target target : targets) {
            HeliosClient client = Utils.getClient(target, err, username);
            if (client == null) {
                return 1;
            }
            clientBuilder.add((Object)new TargetAndClient(target, client));
        }
        ImmutableList clients = clientBuilder.build();
        try {
            result = this.run(options, (List<TargetAndClient>)clients, out, json, stdin);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof TimeoutException)) {
                throw Throwables.propagate((Throwable)cause);
            }
            err.println("Request timed out to master");
            int n = 1;
            return n;
        }
        finally {
            for (TargetAndClient cc : clients) {
                cc.getClient().close();
            }
        }
        return result;
    }

    abstract int run(Namespace var1, List<TargetAndClient> var2, PrintStream var3, boolean var4, BufferedReader var5) throws ExecutionException, InterruptedException, IOException;
}

