/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.spotify.helios.cli.command.ControlCommand;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.Json;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DeploymentGroupListCommand
extends ControlCommand {
    public DeploymentGroupListCommand(Subparser parser) {
        super(parser);
        parser.help("list deployment groups");
    }

    @Override
    int run(Namespace options, HeliosClient client, PrintStream out, boolean json, BufferedReader stdin) throws ExecutionException, InterruptedException, IOException {
        List deploymentGroups = (List)client.listDeploymentGroups().get();
        if (deploymentGroups != null) {
            if (json) {
                out.println(Json.asPrettyStringUnchecked((Object)deploymentGroups));
            } else {
                for (String deploymentGroup : deploymentGroups) {
                    out.println(deploymentGroup);
                }
            }
            return 0;
        }
        out.println("Failed to list deployment groups");
        return 1;
    }
}

