/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.spotify.helios.cli.CliConfig;
import com.spotify.helios.cli.Target;
import com.spotify.helios.cli.command.CliCommand;
import com.spotify.helios.cli.command.DeploymentGroupCreateCommand;
import com.spotify.helios.cli.command.DeploymentGroupInspectCommand;
import com.spotify.helios.cli.command.DeploymentGroupListCommand;
import com.spotify.helios.cli.command.DeploymentGroupRemoveCommand;
import com.spotify.helios.cli.command.DeploymentGroupStatusCommand;
import com.spotify.helios.cli.command.DeploymentGroupStopCommand;
import com.spotify.helios.cli.command.DeploymentGroupWatchCommand;
import com.spotify.helios.cli.command.HostDeregisterCommand;
import com.spotify.helios.cli.command.HostListCommand;
import com.spotify.helios.cli.command.HostRegisterCommand;
import com.spotify.helios.cli.command.JobCreateCommand;
import com.spotify.helios.cli.command.JobDeployCommand;
import com.spotify.helios.cli.command.JobHistoryCommand;
import com.spotify.helios.cli.command.JobInspectCommand;
import com.spotify.helios.cli.command.JobListCommand;
import com.spotify.helios.cli.command.JobRemoveCommand;
import com.spotify.helios.cli.command.JobStartCommand;
import com.spotify.helios.cli.command.JobStatusCommand;
import com.spotify.helios.cli.command.JobStopCommand;
import com.spotify.helios.cli.command.JobUndeployCommand;
import com.spotify.helios.cli.command.JobWatchCommand;
import com.spotify.helios.cli.command.MasterListCommand;
import com.spotify.helios.cli.command.RollingUpdateCommand;
import com.spotify.helios.cli.command.VersionCommand;
import com.spotify.helios.common.LoggingConfig;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.FeatureControl;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;

public class CliParser {
    private static final String NAME_AND_VERSION = "Spotify Helios CLI 0.9.13";
    private static final String TESTED_DOCKER_VERSION = "1.6.2";
    private static final String HELP_ISSUES = "Report improvements/bugs at https://github.com/spotify/helios/issues";
    private static final String HELP_WIKI = "For documentation see https://github.com/spotify/helios/tree/master/docs";
    private final Namespace options;
    private final CliCommand command;
    private final LoggingConfig loggingConfig;
    private final Subparsers commandParsers;
    private final CliConfig cliConfig;
    private final List<Target> targets;
    private final String username;
    private boolean json;

    public CliParser(String ... args) throws ArgumentParserException, IOException, URISyntaxException {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"helios").defaultHelp(true).version(String.format("%s%nTested on Docker %s", NAME_AND_VERSION, TESTED_DOCKER_VERSION)).description(String.format("%s%n%n%s%n%s", NAME_AND_VERSION, HELP_ISSUES, HELP_WIKI));
        this.cliConfig = CliConfig.fromUserConfig();
        GlobalArgs globalArgs = this.addGlobalArgs(parser, this.cliConfig, true);
        this.commandParsers = parser.addSubparsers().metavar("COMMAND").title("commands");
        this.setupCommands();
        if (args.length == 0) {
            parser.printHelp();
            throw new ArgumentParserException(parser);
        }
        try {
            this.options = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            this.handleError(parser, e);
            throw e;
        }
        this.command = (CliCommand)this.options.get("command");
        String username = this.options.getString(globalArgs.usernameArg.getDest());
        this.username = username == null ? this.cliConfig.getUsername() : username;
        this.json = Objects.equal((Object)this.options.getBoolean(globalArgs.jsonArg.getDest()), (Object)true);
        this.loggingConfig = new LoggingConfig(this.options.getInt(globalArgs.verbose.getDest()).intValue(), false, null, this.options.getBoolean(globalArgs.noLogSetup.getDest()).booleanValue());
        List explicitEndpoints = this.options.getList(globalArgs.masterArg.getDest());
        List sitesArguments = this.options.getList(globalArgs.sitesArg.getDest());
        List domainsArguments = this.options.getList(globalArgs.domainsArg.getDest());
        String srvName = this.options.getString(globalArgs.srvNameArg.getDest());
        ImmutableList domains = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)domainsArguments, (Iterable)sitesArguments));
        this.targets = this.computeTargets(parser, explicitEndpoints, (List<String>)domains, srvName);
    }

    private List<Target> computeTargets(ArgumentParser parser, List<String> explicitEndpoints, List<String> domainsArguments, String srvName) {
        if (explicitEndpoints != null && !explicitEndpoints.isEmpty()) {
            ArrayList targets = Lists.newArrayListWithExpectedSize((int)explicitEndpoints.size());
            for (String endpoint : explicitEndpoints) {
                targets.add(Target.from(URI.create(endpoint)));
            }
            return targets;
        }
        if (domainsArguments != null && !domainsArguments.isEmpty()) {
            Iterable<String> domains = this.parseDomains(domainsArguments);
            return Target.from(srvName, domains);
        }
        if (!this.cliConfig.getMasterEndpoints().isEmpty()) {
            List<URI> cliConfigMasterEndpoints = this.cliConfig.getMasterEndpoints();
            ArrayList targets = Lists.newArrayListWithExpectedSize((int)cliConfigMasterEndpoints.size());
            for (URI endpoint : cliConfigMasterEndpoints) {
                targets.add(Target.from(endpoint));
            }
            return targets;
        }
        if (!this.cliConfig.getDomainsString().isEmpty()) {
            Iterable<String> domains = this.parseDomainsString(this.cliConfig.getDomainsString());
            return Target.from(srvName, domains);
        }
        this.handleError(parser, new ArgumentParserException("no masters specified.  Use the -z or -d option to specify which helios cluster/master to connect to", parser));
        return ImmutableList.of();
    }

    private Iterable<String> parseDomains(List<String> domainStrings) {
        LinkedHashSet domains = Sets.newLinkedHashSet();
        for (String s : domainStrings) {
            Iterables.addAll((Collection)domains, this.parseDomainsString(s));
        }
        return domains;
    }

    private Iterable<String> parseDomainsString(String domainsString) {
        return Iterables.filter(Arrays.asList(domainsString.split(",")), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"")));
    }

    private void setupCommands() {
        new JobCreateCommand(this.p("create"));
        new JobRemoveCommand(this.p("remove"));
        new JobInspectCommand(this.p("inspect"));
        new JobDeployCommand(this.p("deploy"));
        new JobUndeployCommand(this.p("undeploy"));
        new JobStartCommand(this.p("start"));
        new JobStopCommand(this.p("stop"));
        new JobHistoryCommand(this.p("history"));
        new JobListCommand(this.p("jobs"));
        new JobStatusCommand(this.p("status"));
        new JobWatchCommand(this.p("watch"));
        new HostListCommand(this.p("hosts"));
        new HostRegisterCommand(this.p("register"));
        new HostDeregisterCommand(this.p("deregister"));
        new MasterListCommand(this.p("masters"));
        new DeploymentGroupCreateCommand(this.p("create-deployment-group"));
        new DeploymentGroupRemoveCommand(this.p("remove-deployment-group"));
        new DeploymentGroupListCommand(this.p("list-deployment-groups"));
        new DeploymentGroupInspectCommand(this.p("inspect-deployment-group"));
        new DeploymentGroupStatusCommand(this.p("deployment-group-status"));
        new DeploymentGroupWatchCommand(this.p("watch-deployment-group"));
        new RollingUpdateCommand(this.p("rolling-update"));
        new DeploymentGroupStopCommand(this.p("stop-deployment-group"));
        Subparser version = this.p("version").help("print version of master and client");
        new VersionCommand(version);
    }

    private void handleError(ArgumentParser parser, ArgumentParserException e) {
        System.err.println("# Report improvements/bugs at https://github.com/spotify/helios/issues");
        System.err.println("# For documentation see https://github.com/spotify/helios/tree/master/docs");
        System.err.println("# ---------------------------------------------------------------");
        parser.handleError(e);
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean getJson() {
        return this.json;
    }

    private GlobalArgs addGlobalArgs(ArgumentParser parser, CliConfig cliConfig) {
        return new GlobalArgs(parser, cliConfig);
    }

    private GlobalArgs addGlobalArgs(ArgumentParser parser, CliConfig cliConfig, boolean topLevel) {
        return new GlobalArgs(parser, cliConfig, topLevel);
    }

    public Namespace getNamespace() {
        return this.options;
    }

    public CliCommand getCommand() {
        return this.command;
    }

    public LoggingConfig getLoggingConfig() {
        return this.loggingConfig;
    }

    private Subparser p(String name) {
        return this.p(this.commandParsers, name);
    }

    private Subparser p(Subparsers subparsers, String name) {
        Subparser subparser = subparsers.addParser(name, true);
        this.addGlobalArgs((ArgumentParser)subparser, this.cliConfig);
        return subparser;
    }

    private static class GlobalArgs {
        private final Argument masterArg;
        private final Argument sitesArg;
        private final Argument domainsArg;
        private final Argument srvNameArg;
        private final Argument usernameArg;
        private final Argument verbose;
        private final Argument noLogSetup;
        private final Argument jsonArg;
        private final ArgumentGroup globalArgs;
        private final boolean topLevel;

        GlobalArgs(ArgumentParser parser, CliConfig cliConfig) {
            this(parser, cliConfig, false);
        }

        GlobalArgs(ArgumentParser parser, CliConfig cliConfig, boolean topLevel) {
            this.globalArgs = parser.addArgumentGroup("global options");
            this.topLevel = topLevel;
            this.masterArg = this.addArgument("-z", "--master").action((ArgumentAction)Arguments.append()).help("master endpoints");
            this.sitesArg = this.addArgument("-s", "--sites").setDefault(new ArrayList()).action((ArgumentAction)Arguments.append()).help("sites. Deprecated, please use -d/--domains instead.");
            this.domainsArg = this.addArgument("-d", "--domains").setDefault(new ArrayList()).action((ArgumentAction)Arguments.append()).help("domains");
            this.srvNameArg = this.addArgument("--srv-name").setDefault((Object)cliConfig.getSrvName()).help("master srv name");
            this.usernameArg = this.addArgument("-u", "--username").setDefault((Object)System.getProperty("user.name")).help("username");
            this.verbose = this.addArgument("-v", "--verbose").action((ArgumentAction)Arguments.count());
            this.addArgument("--version").action((ArgumentAction)Arguments.version()).help("print version");
            this.jsonArg = this.addArgument("--json").action((ArgumentAction)Arguments.storeTrue()).help("json output");
            this.noLogSetup = this.addArgument("--no-log-setup").action((ArgumentAction)Arguments.storeTrue()).help(Arguments.SUPPRESS);
        }

        private Argument addArgument(String ... nameOrFlags) {
            FeatureControl defaultControl = this.topLevel ? null : Arguments.SUPPRESS;
            return this.globalArgs.addArgument(nameOrFlags).setDefault(defaultControl);
        }
    }
}

