/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.cli.command;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;

public class JobStatusFetcher {
    public static Map<JobId, ListenableFuture<JobStatus>> getJobsStatuses(HeliosClient client, Set<JobId> jobIds) throws InterruptedException {
        TreeMap futures = Maps.newTreeMap();
        try {
            Map statuses = (Map)client.jobStatuses(jobIds).get();
            for (Map.Entry entry : statuses.entrySet()) {
                futures.put(entry.getKey(), Futures.immediateFuture(entry.getValue()));
            }
        }
        catch (ExecutionException e) {
            System.err.println("Warning: masters failed batch status fetching.  Falling back to slower job status method");
            for (JobId jobId : jobIds) {
                futures.put(jobId, client.jobStatus(jobId));
            }
        }
        return futures;
    }
}

